"use strict";
/*
 * ATTENTION: An "eval-source-map" devtool has been used.
 * This devtool is neither made for production nor for readable output files.
 * It uses "eval()" calls to create a separate source file with attached SourceMaps in the browser devtools.
 * If you are trying to read the output file, select a different devtool (https://webpack.js.org/configuration/devtool/)
 * or disable the default devtool with "devtool: false".
 * If you are looking for production-ready output files, see mode: "production" (https://webpack.js.org/configuration/mode/).
 */
exports.id = "vendor-chunks/react-confetti";
exports.ids = ["vendor-chunks/react-confetti"];
exports.modules = {

/***/ "(ssr)/../../../node_modules/react-confetti/dist/react-confetti.mjs":
/*!********************************************************************!*\
  !*** ../../../node_modules/react-confetti/dist/react-confetti.mjs ***!
  \********************************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

eval("__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   \"default\": () => (/* binding */ ReactConfetti)\n/* harmony export */ });\n/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react/jsx-runtime */ \"(ssr)/./node_modules/next/dist/server/future/route-modules/app-page/vendored/ssr/react-jsx-runtime.js\");\n/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! react */ \"(ssr)/./node_modules/next/dist/server/future/route-modules/app-page/vendored/ssr/react.js\");\n/* harmony import */ var tween_functions__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! tween-functions */ \"(ssr)/../../../node_modules/tween-functions/index.js\");\n\n\n\n\nfunction degreesToRads(degrees) {\n    return (degrees * Math.PI) / 180;\n}\nfunction randomRange(min, max) {\n    return min + Math.random() * (max - min);\n}\nfunction randomInt(min, max) {\n    return Math.floor(min + Math.random() * (max - min + 1));\n}\n\nvar ParticleShape;\n(function (ParticleShape) {\n    ParticleShape[ParticleShape[\"Circle\"] = 0] = \"Circle\";\n    ParticleShape[ParticleShape[\"Square\"] = 1] = \"Square\";\n    ParticleShape[ParticleShape[\"Strip\"] = 2] = \"Strip\";\n})(ParticleShape || (ParticleShape = {}));\nvar RotationDirection;\n(function (RotationDirection) {\n    RotationDirection[RotationDirection[\"Positive\"] = 1] = \"Positive\";\n    RotationDirection[RotationDirection[\"Negative\"] = -1] = \"Negative\";\n})(RotationDirection || (RotationDirection = {}));\nconst DEFAULT_FRAME_TIME = 1000 / 60;\nclass Particle {\n    constructor(context, getOptions, x, y) {\n        this.getOptions = getOptions;\n        const { colors, initialVelocityX, initialVelocityY } = this.getOptions();\n        this.context = context;\n        this.x = x;\n        this.y = y;\n        this.w = randomRange(5, 20);\n        this.h = randomRange(5, 20);\n        this.radius = randomRange(5, 10);\n        this.vx =\n            typeof initialVelocityX === 'number'\n                ? randomRange(-initialVelocityX, initialVelocityX)\n                : randomRange(initialVelocityX.min, initialVelocityX.max);\n        this.vy =\n            typeof initialVelocityY === 'number'\n                ? randomRange(-initialVelocityY, 0)\n                : randomRange(initialVelocityY.min, initialVelocityY.max);\n        this.shape = randomInt(0, 2);\n        this.angle = degreesToRads(randomRange(0, 360));\n        this.angularSpin = randomRange(-0.2, 0.2);\n        this.color = colors[Math.floor(Math.random() * colors.length)];\n        this.rotateY = randomRange(0, 1);\n        this.rotationDirection = randomRange(0, 1)\n            ? RotationDirection.Positive\n            : RotationDirection.Negative;\n    }\n    update(elapsed) {\n        const { gravity, wind, friction, opacity, drawShape } = this.getOptions();\n        const frameTimeMultiplier = elapsed / DEFAULT_FRAME_TIME;\n        this.x += this.vx * frameTimeMultiplier;\n        this.y += this.vy * frameTimeMultiplier;\n        this.vy += gravity * frameTimeMultiplier;\n        this.vx += wind * frameTimeMultiplier;\n        this.vx *= friction ** frameTimeMultiplier;\n        this.vy *= friction ** frameTimeMultiplier;\n        if (this.rotateY >= 1 &&\n            this.rotationDirection === RotationDirection.Positive) {\n            this.rotationDirection = RotationDirection.Negative;\n        }\n        else if (this.rotateY <= -1 &&\n            this.rotationDirection === RotationDirection.Negative) {\n            this.rotationDirection = RotationDirection.Positive;\n        }\n        const rotateDelta = 0.1 * this.rotationDirection * frameTimeMultiplier;\n        this.rotateY += rotateDelta;\n        this.angle += this.angularSpin;\n        this.context.save();\n        this.context.translate(this.x, this.y);\n        this.context.rotate(this.angle);\n        this.context.scale(1, this.rotateY);\n        this.context.rotate(this.angle);\n        this.context.beginPath();\n        this.context.fillStyle = this.color;\n        this.context.strokeStyle = this.color;\n        this.context.globalAlpha = opacity;\n        this.context.lineCap = 'round';\n        this.context.lineWidth = 2;\n        if (drawShape && typeof drawShape === 'function') {\n            drawShape.call(this, this.context);\n        }\n        else {\n            switch (this.shape) {\n                case ParticleShape.Circle: {\n                    this.context.beginPath();\n                    this.context.arc(0, 0, this.radius, 0, 2 * Math.PI);\n                    this.context.fill();\n                    break;\n                }\n                case ParticleShape.Square: {\n                    this.context.fillRect(-this.w / 2, -this.h / 2, this.w, this.h);\n                    break;\n                }\n                case ParticleShape.Strip: {\n                    this.context.fillRect(-this.w / 6, -this.h / 2, this.w / 3, this.h);\n                    break;\n                }\n            }\n        }\n        this.context.closePath();\n        this.context.restore();\n    }\n}\n\nclass ParticleGenerator {\n    constructor(canvas, getOptions) {\n        this.x = 0;\n        this.y = 0;\n        this.w = 0;\n        this.h = 0;\n        this.lastNumberOfPieces = 0;\n        this.tweenProgress = 0;\n        this.tweenFrom = 0;\n        this.particles = [];\n        this.particlesGenerated = 0;\n        this.removeParticleAt = (i) => {\n            this.particles.splice(i, 1);\n        };\n        this.getParticle = () => {\n            const newParticleX = randomRange(this.x, this.w + this.x);\n            const newParticleY = randomRange(this.y, this.h + this.y);\n            return new Particle(this.context, this.getOptions, newParticleX, newParticleY);\n        };\n        this.animate = (elapsed) => {\n            const { canvas, context, particlesGenerated, lastNumberOfPieces } = this;\n            const { run, recycle, numberOfPieces, debug, tweenFunction, tweenDuration, } = this.getOptions();\n            if (!run) {\n                return false;\n            }\n            const nP = this.particles.length;\n            const activeCount = recycle ? nP : particlesGenerated;\n            // Initial population\n            if (activeCount < numberOfPieces) {\n                // Use the numberOfPieces prop as a key to reset the easing timing\n                if (lastNumberOfPieces !== numberOfPieces) {\n                    this.tweenProgress = 0;\n                    this.tweenFrom = activeCount;\n                    this.lastNumberOfPieces = numberOfPieces;\n                }\n                // Clamp tweenProgress between 0 and tweenDuration\n                this.tweenProgress = Math.min(tweenDuration, Math.max(0, this.tweenProgress + elapsed));\n                const tweenedVal = tweenFunction(this.tweenProgress, this.tweenFrom, numberOfPieces, tweenDuration);\n                const numToAdd = Math.round(tweenedVal - activeCount);\n                for (let i = 0; i < numToAdd; i++) {\n                    this.particles.push(this.getParticle());\n                }\n                this.particlesGenerated += numToAdd;\n            }\n            if (debug) {\n                // Draw debug text\n                context.font = '12px sans-serif';\n                context.fillStyle = '#333';\n                context.textAlign = 'right';\n                context.fillText(`Particles: ${nP}`, canvas.width - 10, canvas.height - 20);\n            }\n            // Maintain the population, iterating backwards to prevent issues when removing particles\n            for (let i = this.particles.length - 1; i >= 0; i--) {\n                const p = this.particles[i];\n                // Update each particle's position\n                p.update(elapsed);\n                // Prune the off-canvas particles\n                if (p.y > canvas.height ||\n                    p.y < -100 ||\n                    p.x > canvas.width + 100 ||\n                    p.x < -100) {\n                    if (recycle && activeCount <= numberOfPieces) {\n                        // Replace the particle with a brand new one\n                        this.particles[i] = this.getParticle();\n                    }\n                    else {\n                        this.removeParticleAt(i);\n                    }\n                }\n            }\n            return nP > 0 || activeCount < numberOfPieces;\n        };\n        this.canvas = canvas;\n        const ctx = this.canvas.getContext('2d');\n        if (!ctx) {\n            throw new Error('Could not get canvas context');\n        }\n        this.context = ctx;\n        this.getOptions = getOptions;\n    }\n}\n\nconst confettiDefaults = {\n    width: typeof window !== 'undefined' ? window.innerWidth : 300,\n    height: typeof window !== 'undefined' ? window.innerHeight : 200,\n    numberOfPieces: 200,\n    friction: 0.99,\n    wind: 0,\n    gravity: 0.1,\n    initialVelocityX: 4,\n    initialVelocityY: 10,\n    colors: [\n        '#f44336',\n        '#e91e63',\n        '#9c27b0',\n        '#673ab7',\n        '#3f51b5',\n        '#2196f3',\n        '#03a9f4',\n        '#00bcd4',\n        '#009688',\n        '#4CAF50',\n        '#8BC34A',\n        '#CDDC39',\n        '#FFEB3B',\n        '#FFC107',\n        '#FF9800',\n        '#FF5722',\n        '#795548',\n    ],\n    opacity: 1.0,\n    debug: false,\n    tweenFunction: tween_functions__WEBPACK_IMPORTED_MODULE_2__.easeInOutQuad,\n    tweenDuration: 5000,\n    recycle: true,\n    run: true,\n};\nclass Confetti {\n    constructor(canvas, opts) {\n        this.lastFrameTime = 0;\n        this.setOptionsWithDefaults = (opts) => {\n            const computedConfettiDefaults = {\n                confettiSource: {\n                    x: 0,\n                    y: 0,\n                    w: this.canvas.width,\n                    h: 0,\n                },\n            };\n            this._options = {\n                ...computedConfettiDefaults,\n                ...confettiDefaults,\n                ...opts,\n            };\n            Object.assign(this, opts.confettiSource);\n        };\n        this.update = (timestamp = 0) => {\n            const { options: { run, onConfettiComplete, frameRate }, canvas, context, } = this;\n            // Cap elapsed time to 50ms to prevent large time steps\n            const elapsed = Math.min(timestamp - this.lastFrameTime, 50);\n            // Throttle the frame rate if set\n            if (frameRate && elapsed < 1000 / frameRate) {\n                this.rafId = requestAnimationFrame(this.update);\n                return;\n            }\n            this.lastFrameTime = timestamp - (frameRate ? elapsed % frameRate : 0);\n            if (run) {\n                context.fillStyle = 'white';\n                context.clearRect(0, 0, canvas.width, canvas.height);\n            }\n            if (this.generator.animate(elapsed)) {\n                this.rafId = requestAnimationFrame(this.update);\n            }\n            else {\n                if (onConfettiComplete &&\n                    typeof onConfettiComplete === 'function' &&\n                    this.generator.particlesGenerated > 0) {\n                    onConfettiComplete.call(this, this);\n                }\n                this._options.run = false;\n            }\n        };\n        this.reset = () => {\n            if (this.generator && this.generator.particlesGenerated > 0) {\n                this.generator.particlesGenerated = 0;\n                this.generator.particles = [];\n                this.generator.lastNumberOfPieces = 0;\n            }\n        };\n        this.stop = () => {\n            this.options = { run: false };\n            if (this.rafId) {\n                cancelAnimationFrame(this.rafId);\n                this.rafId = undefined;\n            }\n        };\n        this.canvas = canvas;\n        const ctx = this.canvas.getContext('2d');\n        if (!ctx) {\n            throw new Error('Could not get canvas context');\n        }\n        this.context = ctx;\n        this.generator = new ParticleGenerator(this.canvas, () => this.options);\n        this.options = opts;\n        this.update();\n    }\n    get options() {\n        return this._options;\n    }\n    set options(opts) {\n        const lastRunState = this._options?.run;\n        const lastRecycleState = this._options?.recycle;\n        this.setOptionsWithDefaults(opts);\n        if (this.generator) {\n            Object.assign(this.generator, this.options.confettiSource);\n            if (typeof opts.recycle === 'boolean' &&\n                opts.recycle &&\n                lastRecycleState === false) {\n                this.generator.lastNumberOfPieces = this.generator.particles.length;\n            }\n        }\n        if (typeof opts.run === 'boolean' && opts.run && lastRunState === false) {\n            this.update();\n        }\n    }\n}\n\nconst ref = react__WEBPACK_IMPORTED_MODULE_1__.createRef();\nclass ReactConfettiInternal extends react__WEBPACK_IMPORTED_MODULE_1__.Component {\n    constructor(props) {\n        super(props);\n        this.canvas = react__WEBPACK_IMPORTED_MODULE_1__.createRef();\n        this.canvas = props.canvasRef || ref;\n    }\n    componentDidMount() {\n        if (this.canvas.current) {\n            const opts = extractCanvasProps(this.props)[0];\n            this.confetti = new Confetti(this.canvas.current, opts);\n        }\n    }\n    componentDidUpdate() {\n        const confettiOptions = extractCanvasProps(this.props)[0];\n        if (this.confetti) {\n            this.confetti.options = confettiOptions;\n        }\n    }\n    componentWillUnmount() {\n        if (this.confetti) {\n            this.confetti.stop();\n        }\n        this.confetti = undefined;\n    }\n    render() {\n        const [confettiOptions, passedProps] = extractCanvasProps(this.props);\n        const canvasStyles = {\n            zIndex: 2,\n            position: 'absolute',\n            pointerEvents: 'none',\n            top: 0,\n            left: 0,\n            bottom: 0,\n            right: 0,\n            ...passedProps.style,\n        };\n        return ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(\"canvas\", { width: confettiOptions.width, height: confettiOptions.height, ref: this.canvas, ...passedProps, style: canvasStyles }));\n    }\n}\nReactConfettiInternal.defaultProps = {\n    ...confettiDefaults,\n};\nReactConfettiInternal.displayName = 'ReactConfetti';\nfunction extractCanvasProps(props) {\n    const confettiOptions = {};\n    const refs = {};\n    const rest = {};\n    const confettiOptionKeys = [\n        ...Object.keys(confettiDefaults),\n        'confettiSource',\n        'drawShape',\n        'onConfettiComplete',\n        'frameRate',\n    ];\n    const refProps = ['canvasRef'];\n    for (const prop in props) {\n        const val = props[prop];\n        if (confettiOptionKeys.includes(prop)) {\n            confettiOptions[prop] = val;\n        }\n        else if (refProps.includes(prop)) {\n            refProps[prop] = val;\n        }\n        else {\n            rest[prop] = val;\n        }\n    }\n    return [confettiOptions, rest, refs];\n}\nconst ReactConfetti = react__WEBPACK_IMPORTED_MODULE_1__.forwardRef((props, ref) => (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(ReactConfettiInternal, { canvasRef: ref, ...props }));\n\n\n//# sourceMappingURL=react-confetti.mjs.map\n//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,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\n//# sourceURL=webpack-internal:///(ssr)/../../../node_modules/react-confetti/dist/react-confetti.mjs\n");

/***/ })

};
;