# 🚀 Папка для загрузки на cPanel

## 📦 Что в этой папке

Эта папка содержит **ВСЕ ФАЙЛЫ** которые нужно загрузить на ваш cPanel хостинг.

**Домен:** `landing.trendingnow.ge`

---

## ⚡ Быстрая инструкция

### Шаг 1: Подготовка (на вашем компьютере)

#### 1.1 Настройте email
Откройте файл `.env.production` и настройте email:

```env
# Минимум что нужно изменить:
EMAIL_TO=info@trendingnow.ge           # Куда приходят письма
EMAIL_FROM=noreply@trendingnow.ge      # От кого

# Выберите сервис для отправки email:

# ВАРИАНТ 1: Gmail (проще всего)
SMTP_HOST=smtp.gmail.com
SMTP_PORT=587
SMTP_USER=ваш-email@gmail.com
SMTP_PASSWORD=ваш-app-password         # НЕ обычный пароль!
```

**Как получить App Password для Gmail:**
1. Перейдите: https://myaccount.google.com/apppasswords
2. Создайте пароль для приложения
3. Скопируйте и вставьте в SMTP_PASSWORD

#### 1.2 Соберите проект
```bash
# В корневой папке проекта (не в cpanel!)
cd ..
npm run build
```

После билда папка `.next/` создастся автоматически.

#### 1.3 Скопируйте папку .next
```bash
# В корневой папке проекта
# Windows:
xcopy /E /I .next cpanel\.next

# Или вручную скопируйте папку .next/ в cpanel/
```

---

### Шаг 2: Загрузка на cPanel

#### 2.1 Подключитесь к cPanel
- Откройте **File Manager** в cPanel
- Перейдите в папку для вашего приложения, например:
  - `/home/your-username/landing-app/`
  - ИЛИ создайте новую папку

#### 2.2 Загрузите ВСЕ файлы из папки `cpanel/`

**Что загружаем:**
```
cpanel/
├── .next/              ← ОБЯЗАТЕЛЬНО! (после npm run build)
├── app/
├── components/
├── lib/
├── messages/
├── public/
├── .env.production     ← ОБЯЗАТЕЛЬНО!
├── i18n.ts
├── middleware.ts
├── next.config.js
├── package.json
├── package-lock.json
├── postcss.config.js
├── tailwind.config.js
├── tsconfig.json
└── server.js
```

❗ **НЕ загружайте:** node_modules/ (установятся на сервере)

---

### Шаг 3: Настройка в cPanel

#### 3.1 Откройте "Setup Node.js App"

**Заполните форму:**

| Поле | Значение |
|------|----------|
| **Node.js version** | 18.x или новее |
| **Application mode** | Production |
| **Application root** | `/home/your-username/landing-app` |
| **Application URL** | `landing.trendingnow.ge` |
| **Application startup file** | `server.js` |

#### 3.2 Добавьте Environment Variables

Нажмите "Add Variable" и добавьте ВСЕ переменные из `.env.production`:

```
NODE_ENV=production
NEXT_PUBLIC_SITE_URL=https://landing.trendingnow.ge
EMAIL_TO=info@trendingnow.ge
EMAIL_FROM=noreply@trendingnow.ge
SMTP_HOST=smtp.gmail.com
SMTP_PORT=587
SMTP_USER=ваш-email@gmail.com
SMTP_PASSWORD=ваш-app-password
... и т.д.
```

⚠️ **Важно:** Добавьте ВСЕ активные переменные из файла!

#### 3.3 Нажмите "Create"

---

### Шаг 4: Установка зависимостей

#### 4.1 Откройте Terminal в cPanel

```bash
# Перейдите в папку приложения
cd ~/landing-app

# Установите зависимости (ТОЛЬКО production)
npm install --production

# Это займет 2-5 минут
```

---

### Шаг 5: Запуск

#### 5.1 В "Setup Node.js App"
- Найдите ваше приложение
- Нажмите **"Restart"**
- Статус должен быть: **"Running"** ✅

#### 5.2 Проверьте сайт
Откройте: **https://landing.trendingnow.ge**

---

## 🎯 Проверка работоспособности

### ✅ Что должно работать:
- [ ] Сайт открывается
- [ ] Переключение языков (EN/RU/UA/KA)
- [ ] Все страницы открываются
- [ ] Анимации работают
- [ ] Контактная форма отправляет email
- [ ] Newsletter работает

### 🐛 Если что-то не работает:

#### Сайт не открывается (502 Bad Gateway)
**Решение:**
1. Проверьте логи в cPanel Node.js App
2. Убедитесь что `npm install` выполнен
3. Проверьте что папка `.next/` загружена
4. Restart приложения в cPanel

#### Контактная форма не работает
**Решение:**
1. Проверьте Environment Variables в cPanel
2. Убедитесь что SMTP настройки правильные
3. Проверьте логи: `~/landing-app/logs/err.log`
4. Тест отправки через Terminal:
```bash
cd ~/landing-app
node -e "console.log(process.env.SMTP_HOST)"  # Должен показать ваш SMTP
```

#### 404 на страницах
**Решение:**
1. Убедитесь что `middleware.ts` загружен
2. Проверьте что `i18n.ts` загружен
3. Restart приложения

#### Изображения не загружаются
**Решение:**
1. Проверьте что папка `public/` загружена
2. Проверьте что `NEXT_PUBLIC_SITE_URL` правильный
3. Проверьте права доступа к файлам (755 для папок, 644 для файлов)

---

## 🔄 Обновление сайта

Когда нужно обновить сайт:

```bash
# 1. На локальном компьютере
cd "C:\Users\User\Desktop\GITHUB\PORTFOLIO COMPANY"
npm run build

# 2. Скопируйте .next в cpanel/
xcopy /E /I /Y .next cpanel\.next

# 3. Загрузите только измененные файлы через FTP:
# - Измененные компоненты/страницы
# - Новую папку .next/

# 4. В Terminal cPanel (если изменился package.json):
cd ~/landing-app
npm install --production

# 5. Restart в cPanel Node.js App
```

---

## 📞 Поддержка

### Полезные команды для диагностики:

```bash
# Проверить что Node.js работает
node --version

# Проверить переменные окружения
cd ~/landing-app
node -e "console.log(process.env)"

# Посмотреть логи ошибок
tail -f ~/landing-app/logs/err.log

# Посмотреть логи приложения
tail -f ~/landing-app/logs/out.log

# Проверить запущенные процессы
ps aux | grep node

# Проверить порты
netstat -tulpn | grep 3000
```

---

## ✅ Чеклист развертывания

- [ ] Файл `.env.production` настроен (email, домен)
- [ ] Выполнен `npm run build` в корневой папке
- [ ] Папка `.next/` скопирована в `cpanel/`
- [ ] Все файлы из `cpanel/` загружены на сервер
- [ ] В cPanel создано Node.js приложение
- [ ] Environment Variables добавлены в cPanel
- [ ] Выполнен `npm install --production` на сервере
- [ ] Приложение запущено (статус "Running")
- [ ] Сайт открывается: https://landing.trendingnow.ge
- [ ] Контактная форма работает
- [ ] Все языки переключаются

---

## 🎉 Готово!

Если все пункты выше выполнены - ваш сайт работает!

Если возникли проблемы - проверьте раздел "🐛 Если что-то не работает" выше.

**Удачи! 🚀**

