'use client'

import { motion } from 'framer-motion'
import { Search, Home, ArrowLeft } from 'lucide-react'
import Link from 'next/link'

export function NotFoundClient() {
  return (
    <div className="min-h-screen flex items-center justify-center bg-gray-950 px-4 py-20">
      <div className="max-w-2xl w-full">
        <motion.div
          initial={{ opacity: 0, y: 20 }}
          animate={{ opacity: 1, y: 0 }}
          transition={{ duration: 0.5 }}
          className="text-center"
        >
          {/* 404 Number */}
          <motion.div
            initial={{ scale: 0.5, opacity: 0 }}
            animate={{ scale: 1, opacity: 1 }}
            transition={{ delay: 0.2, type: 'spring', stiffness: 100 }}
            className="mb-8"
          >
            <h1 className="text-[150px] md:text-[200px] font-bold leading-none">
              <span className="text-gradient">404</span>
            </h1>
          </motion.div>

          {/* Message */}
          <motion.div
            initial={{ opacity: 0 }}
            animate={{ opacity: 1 }}
            transition={{ delay: 0.3 }}
          >
            <h2 className="text-3xl md:text-4xl font-bold text-white mb-4">
              Page Not Found
            </h2>
            <p className="text-lg text-gray-400 mb-8 max-w-lg mx-auto">
              The page you're looking for doesn't exist or has been moved. 
              Let's get you back on track!
            </p>

            {/* Action Buttons */}
            <div className="flex flex-col sm:flex-row items-center justify-center gap-4 mb-12">
              <Link href="/">
                <motion.button
                  whileHover={{ scale: 1.05 }}
                  whileTap={{ scale: 0.95 }}
                  className="px-8 py-4 bg-gradient-to-r from-red-500 to-blue-600 text-white rounded-full font-semibold hover:shadow-glow-duo transition-all duration-300 flex items-center gap-2"
                >
                  <Home className="w-5 h-5" />
                  Go Home
                </motion.button>
              </Link>

              <button
                onClick={() => window.history.back()}
                className="px-8 py-4 border border-gray-700 text-white rounded-full font-semibold hover:border-gray-600 hover:bg-gray-800/50 transition-all duration-300 flex items-center gap-2"
              >
                <ArrowLeft className="w-5 h-5" />
                Go Back
              </button>
            </div>

            {/* Quick Links */}
            <div className="bg-gray-800/50 backdrop-blur-sm border border-gray-700 rounded-2xl p-6 max-w-lg mx-auto">
              <h3 className="text-white font-semibold mb-4 flex items-center gap-2 justify-center">
                <Search className="w-5 h-5" />
                Popular Pages
              </h3>
              <div className="grid grid-cols-2 gap-3">
                <Link href="/#about">
                  <motion.div
                    whileHover={{ scale: 1.02 }}
                    className="px-4 py-3 bg-gray-700/50 rounded-lg text-gray-300 hover:text-white hover:bg-gray-700 transition-all duration-200 text-center"
                  >
                    About
                  </motion.div>
                </Link>
                <Link href="/#projects">
                  <motion.div
                    whileHover={{ scale: 1.02 }}
                    className="px-4 py-3 bg-gray-700/50 rounded-lg text-gray-300 hover:text-white hover:bg-gray-700 transition-all duration-200 text-center"
                  >
                    Projects
                  </motion.div>
                </Link>
                <Link href="/#skills">
                  <motion.div
                    whileHover={{ scale: 1.02 }}
                    className="px-4 py-3 bg-gray-700/50 rounded-lg text-gray-300 hover:text-white hover:bg-gray-700 transition-all duration-200 text-center"
                  >
                    Skills
                  </motion.div>
                </Link>
                <Link href="/#contact">
                  <motion.div
                    whileHover={{ scale: 1.02 }}
                    className="px-4 py-3 bg-gray-700/50 rounded-lg text-gray-300 hover:text-white hover:bg-gray-700 transition-all duration-200 text-center"
                  >
                    Contact
                  </motion.div>
                </Link>
              </div>
            </div>
          </motion.div>

          {/* Decorative Elements */}
          <div className="absolute inset-0 overflow-hidden pointer-events-none">
            <div className="absolute w-96 h-96 top-1/4 -left-48 bg-red-500/10 rounded-full blur-3xl"></div>
            <div className="absolute w-96 h-96 bottom-1/4 -right-48 bg-blue-600/10 rounded-full blur-3xl"></div>
          </div>
        </motion.div>
      </div>
    </div>
  )
}

