'use client'

import { Code2, Sparkles, Users, Zap, TrendingUp, GitCommit, FolderOpen, Heart, Download, FileText, Target, Rocket, CheckCircle, ArrowRight } from 'lucide-react'
import { motion } from 'framer-motion'
import { useTranslations } from 'next-intl'

export function About() {
  const t = useTranslations('about')
  
  const team = [
    {
      name: 'Andrew Altair',
      role: 'Bless - MVP Builder',
      avatar: 'https://api.dicebear.com/7.x/avataaars/svg?seed=andrew',
      jewel: '/bless-jewel.svg',
      skills: ['MVP Development', 'React', 'TypeScript', 'Rapid Prototyping'],
      description: 'Takes projects from 0 to +6. Fast iteration, core features, vibe coding.',
      color: 'from-orange-500 to-yellow-500',
    },
    {
      name: 'Seed',
      role: 'Soul - Project Finalizer',
      avatar: 'https://api.dicebear.com/7.x/avataaars/svg?seed=seed',
      jewel: '/soul-jewel.svg',
      skills: ['Production Polish', 'Testing', 'Optimization', 'Deployment'],
      description: 'Upgrades from +6 to +15. Perfects details, ensures quality, production ready.',
      color: 'from-cyan-500 to-blue-500',
    },
  ]

  const journey = [
    { year: '2019', title: 'The Beginning', description: 'Started our coding journey and formed the duo' },
    { year: '2020', title: 'First Projects', description: 'Completed first commercial projects together' },
    { year: '2021', title: 'Full Stack', description: 'Mastered full-stack development as a team' },
    { year: '2022', title: 'Scale Up', description: 'Built enterprise applications for major clients' },
    { year: '2023', title: 'Innovation', description: 'Leading projects with cutting-edge technologies' },
  ]

  const values = [
    {
      icon: <Code2 className="w-6 h-6" />,
      title: 'Clean Code',
      description: 'We write maintainable, scalable code that stands the test of time',
    },
    {
      icon: <Users className="w-6 h-6" />,
      title: 'Collaboration',
      description: 'Two minds working together to solve complex problems',
    },
    {
      icon: <Sparkles className="w-6 h-6" />,
      title: 'Innovation',
      description: 'Always exploring new technologies and best practices',
    },
    {
      icon: <Zap className="w-6 h-6" />,
      title: 'Performance',
      description: 'Optimized solutions that deliver exceptional user experiences',
    },
  ]

  return (
    <section id="about" className="py-20 bg-white dark:bg-gray-950">
      <div className="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
        {/* Header */}
        <motion.div
          initial={{ opacity: 0, y: 20 }}
          whileInView={{ opacity: 1, y: 0 }}
          viewport={{ once: true }}
          transition={{ duration: 0.5 }}
          className="text-center mb-16"
        >
          <h2 className="text-4xl md:text-5xl font-bold mb-4">
            <span className="bg-gradient-to-r from-orange-400 via-purple-500 to-cyan-400 bg-clip-text text-transparent">
              About Bless & Soul
            </span>
          </h2>
          <p className="text-xl text-gray-600 dark:text-gray-400 max-w-3xl mx-auto">
            Two developers, one unified upgrade system. From MVP to masterpiece.
          </p>
        </motion.div>

        {/* Team Cards */}
        <div className="grid md:grid-cols-2 gap-8 mb-20">
          {team.map((member, index) => (
            <motion.div
              key={index}
              initial={{ opacity: 0, x: index === 0 ? -20 : 20 }}
              whileInView={{ opacity: 1, x: 0 }}
              viewport={{ once: true }}
              transition={{ duration: 0.5, delay: index * 0.1 }}
              className="group bg-white dark:bg-gray-800/50 backdrop-blur-sm border border-gray-200 dark:border-gray-700 rounded-2xl p-8 hover:border-gray-300 dark:hover:border-gray-600 transition-all duration-300 hover:shadow-glow-duo relative overflow-hidden"
            >
              {/* Jewel Icon Background */}
              <div className="absolute top-4 right-4 opacity-10 group-hover:opacity-20 transition-opacity">
                <img src={member.jewel} alt="" className="w-32 h-32" />
              </div>

              <div className="relative z-10">
                <div className="flex items-center gap-6 mb-6">
                  <div className={`w-24 h-24 bg-gradient-to-br ${member.color} rounded-full p-1 shadow-lg`}>
                    <img
                      src={member.avatar}
                      alt={member.name}
                      className="w-full h-full rounded-full bg-gray-900"
                    />
                  </div>
                  <div className="flex-1">
                    <div className="flex items-center gap-2 mb-2">
                      <img src={member.jewel} alt="" className="w-8 h-8" />
                      <h3 className="text-2xl font-bold text-gray-900 dark:text-white">{member.name}</h3>
                    </div>
                    <p className={`bg-gradient-to-r ${member.color} bg-clip-text text-transparent font-bold text-lg`}>
                      {member.role}
                    </p>
                  </div>
                </div>

                <p className="text-gray-700 dark:text-gray-300 mb-4 text-sm leading-relaxed">
                  {member.description}
                </p>

                <div className="flex flex-wrap gap-2">
                  {member.skills.map((skill, i) => (
                    <span
                      key={i}
                      className={`px-3 py-1 bg-gradient-to-r ${member.color} bg-opacity-10 border border-gray-300 dark:border-gray-700 text-gray-700 dark:text-gray-300 rounded-full text-sm`}
                    >
                      {skill}
                    </span>
                  ))}
                </div>
              </div>
            </motion.div>
          ))}
        </div>

        {/* Who We Are Section */}
        <motion.div
          initial={{ opacity: 0, y: 20 }}
          whileInView={{ opacity: 1, y: 0 }}
          viewport={{ once: true }}
          transition={{ duration: 0.5 }}
          className="mb-20"
        >
          <div className="max-w-4xl mx-auto">
            <h3 className="text-3xl font-bold text-gray-900 dark:text-white mb-6 text-center">Who We Are</h3>
            <div className="bg-white/50 dark:bg-gray-800/30 backdrop-blur-sm border border-gray-200 dark:border-gray-700 rounded-2xl p-8 md:p-12">
              <p className="text-lg text-gray-700 dark:text-gray-300 leading-relaxed mb-6">
                Hi! We're a passionate duo of full-stack developers based in San Francisco. Our journey into tech started with curiosity and has evolved into a deep love for creating digital solutions that solve real-world problems.
              </p>
              <p className="text-lg text-gray-700 dark:text-gray-300 leading-relaxed mb-6">
                We specialize in modern web technologies including <span className="text-gradient font-semibold">React, TypeScript, Node.js</span>, and cloud platforms. What drives us is the constant evolution of technology and the endless possibilities it creates for innovation and positive impact.
              </p>
              <p className="text-lg text-gray-700 dark:text-gray-300 leading-relaxed">
                Together, we combine <span className="text-gradient font-semibold">frontend elegance with backend robustness</span>, delivering complete solutions that not only meet requirements but exceed expectations. Our complementary skills allow us to approach problems from multiple angles, resulting in more creative and efficient solutions.
              </p>
            </div>
          </div>
        </motion.div>

        {/* Philosophy Section - MVP vs FVP */}
        <motion.div
          initial={{ opacity: 0, y: 20 }}
          whileInView={{ opacity: 1, y: 0 }}
          viewport={{ once: true }}
          transition={{ duration: 0.5 }}
          className="mb-20"
        >
          <h3 className="text-3xl font-bold text-gray-900 dark:text-white text-center mb-4">
            {t('philosophy.title')}
          </h3>
          <p className="text-lg text-gray-600 dark:text-gray-400 text-center mb-12 max-w-2xl mx-auto">
            {t('philosophy.subtitle')}
          </p>

          {/* MVP vs FVP Cards */}
          <div className="grid md:grid-cols-2 gap-8 mb-12">
            {/* MVP Card */}
            <motion.div
              initial={{ opacity: 0, x: -20 }}
              whileInView={{ opacity: 1, x: 0 }}
              viewport={{ once: true }}
              transition={{ duration: 0.5 }}
              className="group relative"
            >
              <div className="absolute inset-0 bg-gradient-to-br from-orange-500 to-yellow-500 rounded-2xl opacity-10 group-hover:opacity-20 transition-opacity"></div>
              <div className="relative bg-white/80 dark:bg-gray-800/50 backdrop-blur-sm border-2 border-orange-500/30 dark:border-orange-500/40 rounded-2xl p-8 h-full hover:shadow-xl transition-all duration-300">
                <div className="flex items-center justify-between mb-6">
                  <span className="px-4 py-2 bg-gradient-to-r from-orange-500 to-yellow-500 text-white rounded-full text-sm font-bold">
                    {t('philosophy.mvp.badge')}
                  </span>
                  <Rocket className="w-8 h-8 text-orange-500" />
                </div>

                <h4 className="text-2xl font-bold text-gray-900 dark:text-white mb-2">
                  {t('philosophy.mvp.title')}
                </h4>
                <p className="text-lg text-orange-600 dark:text-orange-400 font-semibold mb-6">
                  {t('philosophy.mvp.subtitle')}
                </p>

                <div className="space-y-4 mb-6">
                  <div>
                    <div className="flex items-center gap-2 mb-2">
                      <Target className="w-5 h-5 text-orange-500" />
                      <span className="font-semibold text-gray-900 dark:text-white">{t('philosophy.mvp.focus')}</span>
                    </div>
                    <p className="text-sm text-gray-600 dark:text-gray-400 pl-7">
                      {t('philosophy.mvp.focusDesc')}
                    </p>
                  </div>

                  <div>
                    <div className="flex items-center gap-2 mb-2">
                      <Zap className="w-5 h-5 text-orange-500" />
                      <span className="font-semibold text-gray-900 dark:text-white">{t('philosophy.mvp.goal')}</span>
                    </div>
                    <p className="text-sm text-gray-600 dark:text-gray-400 pl-7">
                      {t('philosophy.mvp.goalDesc')}
                    </p>
                  </div>

                  <div>
                    <div className="flex items-center gap-2 mb-2">
                      <Users className="w-5 h-5 text-orange-500" />
                      <span className="font-semibold text-gray-900 dark:text-white">{t('philosophy.mvp.userExperience')}</span>
                    </div>
                    <p className="text-sm text-gray-600 dark:text-gray-400 pl-7">
                      {t('philosophy.mvp.userExperienceDesc')}
                    </p>
                  </div>
                </div>

                <div className="space-y-2">
                  {(['Fast market entry', 'Early user feedback', 'Hypothesis validation', 'Resource efficiency', 'Iterative learning'] as const).map((benefit, i) => (
                    <div key={i} className="flex items-center gap-2">
                      <CheckCircle className="w-4 h-4 text-orange-500 flex-shrink-0" />
                      <span className="text-sm text-gray-700 dark:text-gray-300">
                        {t(`philosophy.mvp.benefits.${i}`)}
                      </span>
                    </div>
                  ))}
                </div>
              </div>
            </motion.div>

            {/* FVP Card */}
            <motion.div
              initial={{ opacity: 0, x: 20 }}
              whileInView={{ opacity: 1, x: 0 }}
              viewport={{ once: true }}
              transition={{ duration: 0.5 }}
              className="group relative"
            >
              <div className="absolute inset-0 bg-gradient-to-br from-cyan-500 to-blue-500 rounded-2xl opacity-10 group-hover:opacity-20 transition-opacity"></div>
              <div className="relative bg-white/80 dark:bg-gray-800/50 backdrop-blur-sm border-2 border-cyan-500/30 dark:border-cyan-500/40 rounded-2xl p-8 h-full hover:shadow-xl transition-all duration-300">
                <div className="flex items-center justify-between mb-6">
                  <span className="px-4 py-2 bg-gradient-to-r from-cyan-500 to-blue-500 text-white rounded-full text-sm font-bold">
                    {t('philosophy.fvp.badge')}
                  </span>
                  <Sparkles className="w-8 h-8 text-cyan-500" />
                </div>

                <h4 className="text-2xl font-bold text-gray-900 dark:text-white mb-2">
                  {t('philosophy.fvp.title')}
                </h4>
                <p className="text-lg text-cyan-600 dark:text-cyan-400 font-semibold mb-6">
                  {t('philosophy.fvp.subtitle')}
                </p>

                <div className="space-y-4 mb-6">
                  <div>
                    <div className="flex items-center gap-2 mb-2">
                      <Target className="w-5 h-5 text-cyan-500" />
                      <span className="font-semibold text-gray-900 dark:text-white">{t('philosophy.fvp.focus')}</span>
                    </div>
                    <p className="text-sm text-gray-600 dark:text-gray-400 pl-7">
                      {t('philosophy.fvp.focusDesc')}
                    </p>
                  </div>

                  <div>
                    <div className="flex items-center gap-2 mb-2">
                      <Zap className="w-5 h-5 text-cyan-500" />
                      <span className="font-semibold text-gray-900 dark:text-white">{t('philosophy.fvp.goal')}</span>
                    </div>
                    <p className="text-sm text-gray-600 dark:text-gray-400 pl-7">
                      {t('philosophy.fvp.goalDesc')}
                    </p>
                  </div>

                  <div>
                    <div className="flex items-center gap-2 mb-2">
                      <Users className="w-5 h-5 text-cyan-500" />
                      <span className="font-semibold text-gray-900 dark:text-white">{t('philosophy.fvp.userExperience')}</span>
                    </div>
                    <p className="text-sm text-gray-600 dark:text-gray-400 pl-7">
                      {t('philosophy.fvp.userExperienceDesc')}
                    </p>
                  </div>
                </div>

                <div className="space-y-2">
                  {(['Strong first impression', 'Complete feature sets', 'Polished UI/UX', 'Competitive edge', 'User delight'] as const).map((benefit, i) => (
                    <div key={i} className="flex items-center gap-2">
                      <CheckCircle className="w-4 h-4 text-cyan-500 flex-shrink-0" />
                      <span className="text-sm text-gray-700 dark:text-gray-300">
                        {t(`philosophy.fvp.benefits.${i}`)}
                      </span>
                    </div>
                  ))}
                </div>
              </div>
            </motion.div>
          </div>

          {/* Synergy Section */}
          <motion.div
            initial={{ opacity: 0, y: 20 }}
            whileInView={{ opacity: 1, y: 0 }}
            viewport={{ once: true }}
            transition={{ duration: 0.5, delay: 0.2 }}
            className="max-w-4xl mx-auto"
          >
            <div className="relative">
              <div className="absolute inset-0 bg-gradient-to-r from-orange-500/10 via-purple-500/10 to-cyan-500/10 rounded-2xl"></div>
              <div className="relative bg-white/80 dark:bg-gray-800/50 backdrop-blur-sm border border-gray-200 dark:border-gray-700 rounded-2xl p-8 md:p-12">
                <div className="text-center mb-8">
                  <h4 className="text-2xl font-bold bg-gradient-to-r from-orange-500 via-purple-500 to-cyan-500 bg-clip-text text-transparent mb-4">
                    {t('philosophy.synergy.title')}
                  </h4>
                  <p className="text-lg text-gray-700 dark:text-gray-300">
                    {t('philosophy.synergy.description')}
                  </p>
                </div>

                <div className="space-y-4 mb-8">
                  {[0, 1, 2, 3].map((i) => (
                    <div key={i} className="flex items-center justify-between gap-4 p-4 bg-gradient-to-r from-orange-500/5 to-cyan-500/5 rounded-xl">
                      <div className="flex items-center gap-3 flex-1">
                        <div className="w-2 h-2 bg-orange-500 rounded-full"></div>
                        <span className="text-sm md:text-base text-gray-700 dark:text-gray-300">
                          {t(`philosophy.synergy.balance.${i}.left`)}
                        </span>
                      </div>
                      <ArrowRight className="w-5 h-5 text-purple-500 flex-shrink-0" />
                      <div className="flex items-center gap-3 flex-1 justify-end">
                        <span className="text-sm md:text-base text-gray-700 dark:text-gray-300 text-right">
                          {t(`philosophy.synergy.balance.${i}.right`)}
                        </span>
                        <div className="w-2 h-2 bg-cyan-500 rounded-full"></div>
                      </div>
                    </div>
                  ))}
                </div>

                <div className="text-center">
                  <p className="text-base text-gray-600 dark:text-gray-400 italic">
                    {t('philosophy.synergy.result')}
                  </p>
                </div>
              </div>
            </div>
          </motion.div>
        </motion.div>

        {/* By the Numbers Section */}
        <motion.div
          initial={{ opacity: 0, y: 20 }}
          whileInView={{ opacity: 1, y: 0 }}
          viewport={{ once: true }}
          transition={{ duration: 0.5 }}
          className="mb-20"
        >
          <h3 className="text-3xl font-bold text-gray-900 dark:text-white text-center mb-12">By the Numbers</h3>
          <div className="grid grid-cols-2 lg:grid-cols-4 gap-6">
            {[
              {
                icon: <TrendingUp className="w-8 h-8" />,
                value: '5+',
                label: 'Years Coding',
                description: 'Professional development experience',
              },
              {
                icon: <GitCommit className="w-8 h-8" />,
                value: '2.8k+',
                label: 'Commits',
                description: 'Lines of code and contributions',
              },
              {
                icon: <FolderOpen className="w-8 h-8" />,
                value: '50+',
                label: 'Projects',
                description: 'Completed applications and tools',
              },
              {
                icon: <Heart className="w-8 h-8" />,
                value: '∞',
                label: 'Passion',
                description: 'For creating meaningful solutions',
              },
            ].map((stat, index) => (
              <motion.div
                key={index}
                initial={{ opacity: 0, scale: 0.9 }}
                whileInView={{ opacity: 1, scale: 1 }}
                viewport={{ once: true }}
                transition={{ duration: 0.5, delay: index * 0.1 }}
                className="bg-white/80 dark:bg-gray-800/50 backdrop-blur-sm border border-gray-200 dark:border-gray-700 rounded-2xl p-6 hover:border-gray-300 dark:hover:border-gray-600 transition-all duration-300 hover:shadow-glow-duo text-center group"
              >
                <div className="w-16 h-16 bg-gradient-to-br from-red-500 to-blue-600 rounded-full flex items-center justify-center mx-auto mb-4 shadow-glow-duo group-hover:scale-110 transition-transform duration-300">
                  <div className="text-white">{stat.icon}</div>
                </div>
                <div className="text-4xl font-bold text-gradient mb-2">{stat.value}</div>
                <div className="text-lg font-semibold text-gray-900 dark:text-white mb-1">{stat.label}</div>
                <div className="text-sm text-gray-600 dark:text-gray-400">{stat.description}</div>
              </motion.div>
            ))}
          </div>
        </motion.div>

        {/* Journey Timeline */}
        <motion.div
          initial={{ opacity: 0, y: 20 }}
          whileInView={{ opacity: 1, y: 0 }}
          viewport={{ once: true }}
          transition={{ duration: 0.5 }}
          className="mb-20"
        >
          <h3 className="text-3xl font-bold text-gray-900 dark:text-white text-center mb-12">Our Journey</h3>
          <div className="relative">
            {/* Enhanced Timeline Line with Glow Effect */}
            <div className="absolute left-1/2 transform -translate-x-1/2 h-full w-1 bg-gradient-to-b from-red-500 via-purple-500 to-blue-600 hidden md:block shadow-lg">
              <div className="absolute inset-0 bg-gradient-to-b from-red-500 via-purple-500 to-blue-600 blur-sm opacity-50"></div>
            </div>
            
            <div className="space-y-12">
              {journey.map((item, index) => (
                <motion.div
                  key={index}
                  initial={{ opacity: 0, x: index % 2 === 0 ? -20 : 20 }}
                  whileInView={{ opacity: 1, x: 0 }}
                  viewport={{ once: true }}
                  transition={{ duration: 0.5, delay: index * 0.1 }}
                  className={`flex items-center gap-8 ${
                    index % 2 === 0 ? 'md:flex-row' : 'md:flex-row-reverse'
                  } flex-col md:flex-row`}
                >
                  <div className={`flex-1 ${index % 2 === 0 ? 'md:text-right' : 'md:text-left'} text-center md:text-left`}>
                    <div className="group bg-white/80 dark:bg-gray-800/50 backdrop-blur-sm border border-gray-200 dark:border-gray-700 rounded-xl p-6 hover:border-gray-300 dark:hover:border-gray-600 transition-all duration-300 hover:shadow-glow-duo">
                      <span className="inline-block px-3 py-1 text-gradient font-bold text-lg bg-gradient-to-r from-red-500/10 to-blue-600/10 rounded-full mb-2">{item.year}</span>
                      <h4 className="text-xl font-bold text-gray-900 dark:text-white mt-2 mb-2 group-hover:text-gradient transition-colors duration-300">{item.title}</h4>
                      <p className="text-gray-600 dark:text-gray-400">{item.description}</p>
                    </div>
                  </div>
                  
                  {/* Enhanced Timeline Dot with Pulse Animation */}
                  <div className="relative w-6 h-6 flex-shrink-0 hidden md:block">
                    <div className="absolute inset-0 bg-gradient-to-r from-red-500 to-blue-600 rounded-full shadow-glow-duo animate-pulse"></div>
                    <div className="absolute inset-0 bg-gradient-to-r from-red-500 to-blue-600 rounded-full blur-md opacity-50"></div>
                    <div className="relative w-full h-full bg-gradient-to-r from-red-500 to-blue-600 rounded-full flex items-center justify-center">
                      <div className="w-2 h-2 bg-white rounded-full"></div>
                    </div>
                  </div>
                  
                  <div className="flex-1"></div>
                </motion.div>
              ))}
            </div>
          </div>
        </motion.div>

        {/* Values */}
        <motion.div
          initial={{ opacity: 0, y: 20 }}
          whileInView={{ opacity: 1, y: 0 }}
          viewport={{ once: true }}
          transition={{ duration: 0.5 }}
        >
          <h3 className="text-3xl font-bold text-gray-900 dark:text-white text-center mb-12">What Drives Us</h3>
          <div className="grid md:grid-cols-2 lg:grid-cols-4 gap-6">
            {values.map((value, index) => (
              <motion.div
                key={index}
                initial={{ opacity: 0, y: 20 }}
                whileInView={{ opacity: 1, y: 0 }}
                viewport={{ once: true }}
                transition={{ duration: 0.5, delay: index * 0.1 }}
                className="bg-white/80 dark:bg-gray-800/50 backdrop-blur-sm border border-gray-200 dark:border-gray-700 rounded-xl p-6 hover:border-gray-300 dark:hover:border-gray-600 transition-all duration-300 hover:shadow-glow-duo text-center"
              >
                <div className="w-14 h-14 bg-gradient-to-br from-red-500 to-blue-600 rounded-xl flex items-center justify-center mx-auto mb-4 shadow-glow-duo">
                  <div className="text-white">{value.icon}</div>
                </div>
                <h4 className="text-lg font-bold text-gray-900 dark:text-white mb-2">{value.title}</h4>
                <p className="text-gray-600 dark:text-gray-400 text-sm">{value.description}</p>
              </motion.div>
            ))}
          </div>
        </motion.div>

        {/* What Drives Me - Motivational Section */}
        <motion.div
          initial={{ opacity: 0, y: 20 }}
          whileInView={{ opacity: 1, y: 0 }}
          viewport={{ once: true }}
          transition={{ duration: 0.5 }}
          className="mb-20"
        >
          <h3 className="text-3xl font-bold text-gray-900 dark:text-white text-center mb-12">What Drives Us</h3>
          <div className="max-w-4xl mx-auto">
            <div className="bg-gradient-to-r from-red-500/10 to-blue-600/10 border border-gray-200 dark:border-gray-700 rounded-2xl p-8 md:p-12 mb-12">
              <p className="text-lg text-gray-700 dark:text-gray-300 leading-relaxed mb-6">
                We're driven by the desire to create technology that enhances people's lives. Whether it's building a seamless user experience, optimizing performance, or solving complex technical challenges, we find joy in the process of turning ideas into reality.
              </p>
              <p className="text-lg text-gray-700 dark:text-gray-300 leading-relaxed">
                Every project is an opportunity to learn something new, push boundaries, and deliver value that makes a difference. We believe in <span className="text-gradient font-semibold">continuous improvement</span>, <span className="text-gradient font-semibold">attention to detail</span>, and creating solutions that stand the test of time.
              </p>
            </div>

            {/* Developer Quote */}
            <motion.div
              initial={{ opacity: 0, scale: 0.95 }}
              whileInView={{ opacity: 1, scale: 1 }}
              viewport={{ once: true }}
              transition={{ duration: 0.5, delay: 0.2 }}
              className="relative"
            >
              <div className="absolute -top-6 -left-6 text-8xl text-red-500/20 font-serif">"</div>
              <div className="bg-white/80 dark:bg-gray-800/50 backdrop-blur-sm border border-gray-200 dark:border-gray-700 rounded-2xl p-8 md:p-12 relative">
                <blockquote className="text-xl md:text-2xl text-gray-800 dark:text-gray-200 font-medium italic mb-6 text-center">
                  The best error message is the one that never shows up.
                </blockquote>
                <div className="text-center">
                  <p className="text-gradient font-semibold text-lg">- Thomas Fuchs</p>
                  <p className="text-gray-600 dark:text-gray-400 text-sm mt-1">on the importance of thoughtful development</p>
                </div>
              </div>
              <div className="absolute -bottom-6 -right-6 text-8xl text-blue-600/20 font-serif rotate-180">"</div>
            </motion.div>

            {/* Core Values Tags */}
            <motion.div
              initial={{ opacity: 0, y: 20 }}
              whileInView={{ opacity: 1, y: 0 }}
              viewport={{ once: true }}
              transition={{ duration: 0.5, delay: 0.3 }}
              className="flex flex-wrap gap-3 justify-center mt-12"
            >
              {['Problem Solving', 'Continuous Learning', 'User Experience', 'Clean Code', 'Innovation', 'Collaboration'].map((tag, index) => (
                <span
                  key={index}
                  className="px-4 py-2 bg-gradient-to-r from-red-500/10 to-blue-600/10 border border-gray-300 dark:border-gray-700 text-gray-700 dark:text-gray-300 rounded-full text-sm font-medium hover:from-red-500/20 hover:to-blue-600/20 transition-all duration-300"
                >
                  {tag}
                </span>
              ))}
            </motion.div>
          </div>
        </motion.div>

        {/* Let's Connect + Resume Download Section */}
        <motion.div
          initial={{ opacity: 0, y: 20 }}
          whileInView={{ opacity: 1, y: 0 }}
          viewport={{ once: true }}
          transition={{ duration: 0.5 }}
          className="text-center"
        >
          <h3 className="text-3xl font-bold text-gray-900 dark:text-white mb-6">Let's Connect</h3>
          <p className="text-xl text-gray-600 dark:text-gray-400 mb-8 max-w-2xl mx-auto">
            Interested in collaborating or just want to chat about technology? We'd love to hear from you!
          </p>
          <div className="flex flex-col sm:flex-row gap-4 justify-center items-center">
            <a
              href="#contact"
              className="px-8 py-4 bg-gradient-to-r from-red-500 to-blue-600 text-white rounded-full font-semibold hover:shadow-glow-duo transition-all duration-300 transform hover:scale-105 inline-flex items-center gap-2"
            >
              <span>Email Us</span>
            </a>
            <a
              href="https://github.com"
              target="_blank"
              rel="noopener noreferrer"
              className="px-8 py-4 border border-gray-300 dark:border-gray-700 text-gray-900 dark:text-white rounded-full font-semibold hover:border-gray-400 dark:hover:border-gray-600 hover:bg-gray-100/50 dark:hover:bg-gray-800/50 transition-all duration-300 inline-flex items-center gap-2"
            >
              <span>GitHub</span>
            </a>
            <a
              href="https://linkedin.com"
              target="_blank"
              rel="noopener noreferrer"
              className="px-8 py-4 border border-gray-300 dark:border-gray-700 text-gray-900 dark:text-white rounded-full font-semibold hover:border-gray-400 dark:hover:border-gray-600 hover:bg-gray-100/50 dark:hover:bg-gray-800/50 transition-all duration-300 inline-flex items-center gap-2"
            >
              <span>LinkedIn</span>
            </a>
          </div>

          {/* Resume Download */}
          <motion.div
            initial={{ opacity: 0, y: 10 }}
            whileInView={{ opacity: 1, y: 0 }}
            viewport={{ once: true }}
            transition={{ duration: 0.5, delay: 0.2 }}
            className="mt-12 pt-12 border-t border-gray-200 dark:border-gray-800"
          >
            <button
              onClick={() => {
                // Create a placeholder resume download
                const link = document.createElement('a')
                link.href = '#'
                link.download = 'Duo-Team-Resume.pdf'
                // In production, this would be: link.href = '/resume/duo-team-resume.pdf'
                alert('Resume download functionality is ready! Add your PDF file to /public/resume/duo-team-resume.pdf')
              }}
              className="group inline-flex items-center gap-3 px-8 py-4 bg-white/80 dark:bg-gray-800/50 backdrop-blur-sm border-2 border-dashed border-gray-300 dark:border-gray-700 text-gray-900 dark:text-white rounded-xl font-semibold hover:border-gray-400 dark:hover:border-gray-600 hover:bg-gray-100 dark:hover:bg-gray-800 transition-all duration-300"
            >
              <FileText className="w-5 h-5 group-hover:text-red-500 transition-colors" />
              <span>View Full Resume</span>
              <Download className="w-5 h-5 group-hover:text-blue-600 transition-colors" />
            </button>
            <p className="text-gray-600 dark:text-gray-500 text-sm mt-3">Download our complete resume and portfolio</p>
          </motion.div>
        </motion.div>
      </div>
    </section>
  )
}

