'use client'

import Link from 'next/link'
import { Github, Linkedin, Twitter, Mail, Heart } from 'lucide-react'

export function Footer() {
  const currentYear = new Date().getFullYear()

  const footerLinks = {
    navigation: [
      { label: 'About', href: '#about' },
      { label: 'Projects', href: '#projects' },
      { label: 'Skills', href: '#skills' },
      { label: 'Contact', href: '#contact' },
    ],
    social: [
      { icon: <Github className="w-5 h-5" />, href: 'https://github.com', label: 'GitHub' },
      { icon: <Linkedin className="w-5 h-5" />, href: 'https://linkedin.com', label: 'LinkedIn' },
      { icon: <Twitter className="w-5 h-5" />, href: 'https://twitter.com', label: 'Twitter' },
      { icon: <Mail className="w-5 h-5" />, href: 'mailto:duoteam.dev@email.com', label: 'Email' },
    ],
  }

  return (
    <footer className="bg-gray-100 dark:bg-gray-950 border-t border-gray-200 dark:border-gray-800">
      <div className="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8 py-12">
        <div className="grid grid-cols-1 md:grid-cols-3 gap-8 mb-8">
          {/* Brand */}
          <div>
            <div className="flex items-center space-x-3 mb-4">
              <img src="/bless-soul-logo.svg" alt="Bless & Soul" className="w-12 h-12" />
              <div>
                <span className="text-xl font-bold bg-gradient-to-r from-orange-400 via-purple-500 to-cyan-400 bg-clip-text text-transparent">
                  Bless & Soul
                </span>
                <p className="text-xs text-gray-500">Development Duo</p>
              </div>
            </div>
            <p className="text-gray-600 dark:text-gray-400 text-sm mb-4">
              Like MU Online jewels, we upgrade your project in stages. MVP to production, systematically enhanced.
            </p>
            <div className="flex gap-3">
              {footerLinks.social.map((social, index) => (
                <a
                  key={index}
                  href={social.href}
                  target="_blank"
                  rel="noopener noreferrer"
                  className="w-10 h-10 flex items-center justify-center bg-white/80 dark:bg-gray-800/50 border border-gray-300 dark:border-gray-700 rounded-lg text-gray-600 dark:text-gray-400 hover:text-gray-900 dark:hover:text-white hover:border-gray-400 dark:hover:border-gray-600 hover:shadow-glow-duo transition-all duration-300"
                  aria-label={social.label}
                >
                  {social.icon}
                </a>
              ))}
            </div>
          </div>

          {/* Quick Links */}
          <div>
            <h3 className="text-gray-900 dark:text-white font-semibold mb-4">Quick Links</h3>
            <ul className="space-y-2">
              {footerLinks.navigation.map((link, index) => (
                <li key={index}>
                  <Link
                    href={link.href}
                    className="text-gray-600 dark:text-gray-400 hover:text-gray-900 dark:hover:text-white transition-colors inline-block hover:translate-x-1 duration-200"
                  >
                    {link.label}
                  </Link>
                </li>
              ))}
            </ul>
          </div>

          {/* Contact Info */}
          <div>
            <h3 className="text-gray-900 dark:text-white font-semibold mb-4">Get In Touch</h3>
            <ul className="space-y-2 text-gray-600 dark:text-gray-400 text-sm">
              <li>
                <a href="mailto:duoteam.dev@email.com" className="hover:text-gray-900 dark:hover:text-white transition-colors">
                  duoteam.dev@email.com
                </a>
              </li>
              <li>
                <a href="tel:+15551234567" className="hover:text-gray-900 dark:hover:text-white transition-colors">
                  +1 (555) 123-4567
                </a>
              </li>
              <li>San Francisco, CA</li>
              <li className="pt-2">
                <span className="inline-flex items-center px-3 py-1 bg-gradient-to-r from-red-500/10 to-blue-600/10 border border-gray-300 dark:border-gray-700 rounded-full text-xs">
                  <span className="w-2 h-2 bg-green-500 rounded-full mr-2 animate-pulse"></span>
                  Available for new projects
                </span>
              </li>
            </ul>
          </div>
        </div>

        {/* Bottom Bar */}
        <div className="pt-8 border-t border-gray-200 dark:border-gray-800 flex flex-col md:flex-row items-center justify-between gap-4">
          <p className="text-gray-600 dark:text-gray-400 text-sm text-center md:text-left">
            © {currentYear} Bless & Soul. All rights reserved.
          </p>
          <div className="flex items-center gap-4 text-xs text-gray-500">
            <span className="flex items-center gap-1">
              <img src="/bless-jewel.svg" alt="Bless" className="w-4 h-4" />
              <span className="text-orange-400">Andrew</span>
            </span>
            <span>+</span>
            <span className="flex items-center gap-1">
              <img src="/soul-jewel.svg" alt="Soul" className="w-4 h-4" />
              <span className="text-cyan-400">Seed</span>
            </span>
          </div>
          <p className="text-gray-600 dark:text-gray-400 text-sm flex items-center gap-1">
            BUILT WITH <Heart className="w-4 h-4 text-red-500 animate-pulse" /> AND CODE
          </p>
        </div>
      </div>
    </footer>
  )
}

