'use client'

import { ArrowRight, Github, Linkedin, Mail } from 'lucide-react'
import Link from 'next/link'
import { motion } from 'framer-motion'
import { useTranslations } from 'next-intl'

export function Hero() {
  const t = useTranslations('hero')
  
  return (
    <section id="home" className="relative min-h-screen flex items-center justify-center overflow-hidden pt-16 bg-gradient-to-br from-gray-50 via-white to-gray-100 dark:from-gray-900 dark:via-gray-950 dark:to-gray-900">
      {/* Animated Background */}
      <div className="absolute inset-0 overflow-hidden">
        <div className="absolute w-[500px] h-[500px] -top-48 -left-48 bg-red-500/10 dark:bg-red-500/20 rounded-full blur-3xl animate-pulse-slow"></div>
        <div className="absolute w-[600px] h-[600px] -bottom-48 -right-48 bg-blue-600/10 dark:bg-blue-600/20 rounded-full blur-3xl animate-pulse-slow delay-1000"></div>
        <div className="absolute w-[400px] h-[400px] top-1/2 left-1/2 -translate-x-1/2 -translate-y-1/2 bg-gradient-to-r from-red-500/5 to-blue-600/5 dark:from-red-500/10 dark:to-blue-600/10 rounded-full blur-3xl animate-float"></div>
      </div>

      <div className="relative max-w-7xl mx-auto px-4 sm:px-6 lg:px-8 py-20">
        <div className="text-center">
          {/* Badge */}
          <motion.div
            initial={{ opacity: 0, y: 20 }}
            animate={{ opacity: 1, y: 0 }}
            transition={{ duration: 0.5 }}
            className="inline-flex items-center px-4 py-2 mb-8 rounded-full border border-gray-200 dark:border-gray-800 bg-white/80 dark:bg-gray-900/50 backdrop-blur-sm"
          >
            <span className="w-2 h-2 bg-gradient-to-r from-red-500 to-blue-600 rounded-full mr-2 animate-pulse"></span>
            <span className="text-sm text-gray-700 dark:text-gray-300">{t('badge')}</span>
          </motion.div>

          {/* Logo */}
          <motion.div
            initial={{ opacity: 0, scale: 0.5 }}
            animate={{ opacity: 1, scale: 1 }}
            transition={{ duration: 0.5, delay: 0.1 }}
            className="flex items-center justify-center mb-8"
          >
            <img 
              src="/bless-soul-logo.svg" 
              alt="Bless & Soul Logo" 
              className="w-32 h-32 md:w-40 md:h-40 drop-shadow-2xl"
            />
          </motion.div>

          {/* Main Heading */}
          <motion.h1
            initial={{ opacity: 0, y: 20 }}
            animate={{ opacity: 1, y: 0 }}
            transition={{ duration: 0.5, delay: 0.2 }}
            className="text-5xl sm:text-6xl md:text-7xl lg:text-8xl font-bold mb-6"
          >
            <span className="text-gray-900 dark:text-white">{t('greeting')}</span>
            <br />
            <span className="inline-block bg-gradient-to-r from-orange-400 via-purple-500 to-cyan-400 bg-clip-text text-transparent">
              {t('companyName')}
            </span>
          </motion.h1>

          {/* Subtitle */}
          <motion.p
            initial={{ opacity: 0, y: 20 }}
            animate={{ opacity: 1, y: 0 }}
            transition={{ duration: 0.5, delay: 0.3 }}
            className="text-xl sm:text-2xl text-gray-600 dark:text-gray-400 mb-4"
          >
            {t('subtitle')}
          </motion.p>

          {/* Team Members */}
          <motion.div
            initial={{ opacity: 0, y: 20 }}
            animate={{ opacity: 1, y: 0 }}
            transition={{ duration: 0.5, delay: 0.35 }}
            className="flex flex-col sm:flex-row items-center justify-center gap-4 sm:gap-8 mb-8"
          >
            <div className="flex items-center gap-2">
              <img src="/bless-jewel.svg" alt="Bless" className="w-8 h-8 animate-pulse" />
              <span className="text-orange-400 font-semibold text-lg">{t('andrew')}</span>
              <span className="text-gray-600 dark:text-gray-500 text-sm">({t('andrewRole')})</span>
            </div>
            <div className="hidden sm:block text-gray-400 dark:text-gray-600 text-2xl">+</div>
            <div className="flex items-center gap-2">
              <img src="/soul-jewel.svg" alt="Soul" className="w-8 h-8 animate-pulse" />
              <span className="text-cyan-400 font-semibold text-lg">{t('seed')}</span>
              <span className="text-gray-600 dark:text-gray-500 text-sm">({t('seedRole')})</span>
            </div>
          </motion.div>

          {/* Description */}
          <motion.p
            initial={{ opacity: 0, y: 20 }}
            animate={{ opacity: 1, y: 0 }}
            transition={{ duration: 0.5, delay: 0.4 }}
            className="max-w-3xl mx-auto text-lg text-gray-600 dark:text-gray-500 mb-12"
          >
            Like MU Online jewels, we upgrade your project in stages.{' '}
            <span className="text-orange-400 font-semibold">Bless</span> takes it to MVP (+6),{' '}
            <span className="text-cyan-400 font-semibold">Soul</span> perfects it to production (+15). 
            Together, we deliver fully enhanced digital experiences.
          </motion.p>

          {/* CTA Buttons */}
          <motion.div
            initial={{ opacity: 0, y: 20 }}
            animate={{ opacity: 1, y: 0 }}
            transition={{ duration: 0.5, delay: 0.5 }}
            className="flex flex-col sm:flex-row items-center justify-center gap-4 mb-6"
          >
            <Link
              href="#contact"
              className="group px-8 py-4 bg-gradient-to-r from-red-500 to-blue-600 text-white rounded-full font-semibold hover:shadow-glow-duo transition-all duration-300 transform hover:scale-105 flex items-center gap-2"
            >
              {t('getInTouch')}
              <ArrowRight className="w-5 h-5 group-hover:translate-x-1 transition-transform" />
            </Link>
            <Link
              href="#projects"
              className="px-8 py-4 border border-gray-300 dark:border-gray-700 text-gray-900 dark:text-white rounded-full font-semibold hover:border-gray-400 dark:hover:border-gray-600 hover:bg-gray-100/50 dark:hover:bg-gray-800/50 transition-all duration-300"
            >
              {t('viewWork')}
            </Link>
          </motion.div>

          {/* Urgency Indicator */}
          <motion.div
            initial={{ opacity: 0, scale: 0.95 }}
            animate={{ opacity: 1, scale: 1 }}
            transition={{ duration: 0.5, delay: 0.6 }}
            className="flex items-center justify-center gap-2 mb-12"
          >
            <span className="w-2 h-2 bg-green-500 rounded-full animate-pulse"></span>
            <span className="text-sm text-gray-600 dark:text-gray-400">
              Only <span className="font-bold text-gradient">2 project slots</span> available this month
            </span>
          </motion.div>

          {/* Social Links */}
          <motion.div
            initial={{ opacity: 0, y: 20 }}
            animate={{ opacity: 1, y: 0 }}
            transition={{ duration: 0.5, delay: 0.6 }}
            className="flex items-center justify-center gap-6"
          >
            <a
              href="https://github.com"
              target="_blank"
              rel="noopener noreferrer"
              className="w-12 h-12 flex items-center justify-center rounded-full border border-gray-300 dark:border-gray-700 text-gray-600 dark:text-gray-400 hover:text-gray-900 dark:hover:text-white hover:border-red-500 hover:shadow-glow-red transition-all duration-300"
            >
              <Github className="w-5 h-5" />
            </a>
            <a
              href="https://linkedin.com"
              target="_blank"
              rel="noopener noreferrer"
              className="w-12 h-12 flex items-center justify-center rounded-full border border-gray-300 dark:border-gray-700 text-gray-600 dark:text-gray-400 hover:text-gray-900 dark:hover:text-white hover:border-blue-600 hover:shadow-glow-blue transition-all duration-300"
            >
              <Linkedin className="w-5 h-5" />
            </a>
            <a
              href="mailto:contact@duoteam.com"
              className="w-12 h-12 flex items-center justify-center rounded-full border border-gray-300 dark:border-gray-700 text-gray-600 dark:text-gray-400 hover:text-gray-900 dark:hover:text-white hover:border-blue-600 hover:shadow-glow-duo transition-all duration-300"
            >
              <Mail className="w-5 h-5" />
            </a>
          </motion.div>
        </div>

        {/* Scroll Indicator */}
        <motion.div
          initial={{ opacity: 0 }}
          animate={{ opacity: 1 }}
          transition={{ duration: 0.5, delay: 0.7 }}
          className="absolute bottom-8 left-1/2 -translate-x-1/2"
        >
          <div className="w-6 h-10 border-2 border-gray-300 dark:border-gray-700 rounded-full flex justify-center">
            <div className="w-1 h-3 bg-gradient-to-b from-red-500 to-blue-600 rounded-full mt-2 animate-bounce"></div>
          </div>
        </motion.div>
      </div>
    </section>
  )
}

