'use client'

import React from 'react'
import { ConfigProvider } from 'antd'
import { ThemeProvider, useTheme } from 'next-themes'
import { Toaster } from 'react-hot-toast'
import { antdTheme as customAntdTheme, antdLightTheme } from '@/lib/antd-theme'

interface ProvidersProps {
  children: React.ReactNode
}

function AntdConfigProvider({ children }: { children: React.ReactNode }) {
  const { theme } = useTheme()
  const isDark = theme === 'dark'

  const toastStyles = {
    duration: 4000,
    style: {
      background: isDark ? '#1f2937' : '#ffffff',
      color: isDark ? '#f3f4f6' : '#1f2937',
      borderRadius: '12px',
      padding: '16px',
      fontSize: '14px',
      fontWeight: '500',
      boxShadow: isDark 
        ? '0 10px 40px rgba(0, 0, 0, 0.3), 0 0 30px rgba(239, 68, 68, 0.2), 0 0 60px rgba(37, 99, 235, 0.2)'
        : '0 10px 40px rgba(0, 0, 0, 0.1), 0 0 20px rgba(239, 68, 68, 0.1)',
      border: isDark ? '1px solid #374151' : '1px solid #e5e7eb',
      backdropFilter: 'blur(8px)',
    },
    success: {
      iconTheme: {
        primary: '#10b981',
        secondary: isDark ? '#f3f4f6' : '#ffffff',
      },
      style: {
        boxShadow: isDark 
          ? '0 10px 40px rgba(0, 0, 0, 0.3), 0 0 30px rgba(16, 185, 129, 0.3)'
          : '0 10px 40px rgba(0, 0, 0, 0.1), 0 0 20px rgba(16, 185, 129, 0.2)',
        border: isDark ? '1px solid rgba(16, 185, 129, 0.3)' : '1px solid rgba(16, 185, 129, 0.2)',
      },
    },
    error: {
      iconTheme: {
        primary: '#ef4444',
        secondary: isDark ? '#f3f4f6' : '#ffffff',
      },
      style: {
        boxShadow: isDark 
          ? '0 10px 40px rgba(0, 0, 0, 0.3), 0 0 30px rgba(239, 68, 68, 0.3)'
          : '0 10px 40px rgba(0, 0, 0, 0.1), 0 0 20px rgba(239, 68, 68, 0.2)',
        border: isDark ? '1px solid rgba(239, 68, 68, 0.3)' : '1px solid rgba(239, 68, 68, 0.2)',
      },
    },
    loading: {
      iconTheme: {
        primary: '#2563eb',
        secondary: isDark ? '#f3f4f6' : '#ffffff',
      },
      style: {
        boxShadow: isDark 
          ? '0 10px 40px rgba(0, 0, 0, 0.3), 0 0 30px rgba(37, 99, 235, 0.2)'
          : '0 10px 40px rgba(0, 0, 0, 0.1), 0 0 20px rgba(37, 99, 235, 0.2)',
        border: isDark ? '1px solid rgba(37, 99, 235, 0.3)' : '1px solid rgba(37, 99, 235, 0.2)',
      },
    },
  }

  return (
    <ConfigProvider
      theme={isDark ? customAntdTheme : antdLightTheme}
      componentSize="large"
    >
      {children}
      
      {/* Toast Notifications */}
      <Toaster
        position="top-right"
        reverseOrder={false}
        gutter={8}
        containerClassName="toast-container"
        containerStyle={{
          top: 80,
          right: 20,
        }}
        toastOptions={toastStyles}
      />
    </ConfigProvider>
  )
}

export function Providers({ children }: ProvidersProps) {
  return (
    <ThemeProvider
      attribute="class"
      defaultTheme="system"
      enableSystem={true}
      disableTransitionOnChange={false}
    >
      <AntdConfigProvider>
        {children}
      </AntdConfigProvider>
    </ThemeProvider>
  )
}

