'use client'

import { motion } from 'framer-motion'

export function Skills() {
  const skillCategories = [
    {
      title: 'Frontend Development',
      description: 'Creating responsive and interactive user interfaces with modern frameworks',
      skills: [
        { name: 'React', level: 95 },
        { name: 'Next.js', level: 90 },
        { name: 'TypeScript', level: 92 },
        { name: 'Tailwind CSS', level: 88 },
        { name: 'Vue.js', level: 85 },
        { name: 'Angular', level: 80 },
      ],
    },
    {
      title: 'Backend Development',
      description: 'Building scalable server-side applications and robust APIs',
      skills: [
        { name: 'Node.js', level: 93 },
        { name: 'Python', level: 88 },
        { name: 'Express', level: 90 },
        { name: 'Django', level: 85 },
        { name: 'PostgreSQL', level: 87 },
        { name: 'MongoDB', level: 89 },
      ],
    },
    {
      title: 'Cloud & DevOps',
      description: 'Deploying and managing applications with modern DevOps practices',
      skills: [
        { name: 'AWS', level: 86 },
        { name: 'Docker', level: 88 },
        { name: 'Kubernetes', level: 82 },
        { name: 'CI/CD', level: 85 },
        { name: 'Terraform', level: 80 },
        { name: 'Vercel', level: 90 },
      ],
    },
    {
      title: 'Mobile Development',
      description: 'Developing cross-platform mobile applications',
      skills: [
        { name: 'React Native', level: 88 },
        { name: 'Flutter', level: 83 },
        { name: 'Expo', level: 86 },
        { name: 'iOS', level: 80 },
        { name: 'Android', level: 80 },
        { name: 'PWA', level: 87 },
      ],
    },
    {
      title: 'AI & Machine Learning',
      description: 'Implementing intelligent solutions and ML models',
      skills: [
        { name: 'TensorFlow', level: 82 },
        { name: 'PyTorch', level: 80 },
        { name: 'OpenAI', level: 88 },
        { name: 'Langchain', level: 85 },
        { name: 'Hugging Face', level: 83 },
        { name: 'Scikit-learn', level: 81 },
      ],
    },
    {
      title: 'Blockchain & Web3',
      description: 'Building decentralized applications and smart contracts',
      skills: [
        { name: 'Solidity', level: 84 },
        { name: 'Ethereum', level: 82 },
        { name: 'Web3.js', level: 85 },
        { name: 'Smart Contracts', level: 83 },
        { name: 'DeFi', level: 80 },
        { name: 'NFTs', level: 81 },
      ],
    },
  ]

  return (
    <section id="skills" className="py-20 bg-white dark:bg-gray-950">
      <div className="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
        {/* Header */}
        <motion.div
          initial={{ opacity: 0, y: 20 }}
          whileInView={{ opacity: 1, y: 0 }}
          viewport={{ once: true }}
          transition={{ duration: 0.5 }}
          className="text-center mb-16"
        >
          <h2 className="text-4xl md:text-5xl font-bold text-gradient mb-4">Skills & Expertise</h2>
          <p className="text-xl text-gray-600 dark:text-gray-400 max-w-3xl mx-auto">
            A comprehensive overview of our technical skills and expertise across different domains 
            of software development
          </p>
        </motion.div>

        {/* Skills Grid */}
        <div className="grid md:grid-cols-2 lg:grid-cols-3 gap-8">
          {skillCategories.map((category, categoryIndex) => (
            <motion.div
              key={categoryIndex}
              initial={{ opacity: 0, y: 20 }}
              whileInView={{ opacity: 1, y: 0 }}
              viewport={{ once: true }}
              transition={{ duration: 0.5, delay: categoryIndex * 0.1 }}
              className="bg-white dark:bg-gray-800/50 backdrop-blur-sm border border-gray-200 dark:border-gray-700 rounded-2xl p-6 hover:border-gray-300 dark:hover:border-gray-600 transition-all duration-300 hover:shadow-glow-duo"
            >
              <h3 className="text-xl font-bold text-gray-900 dark:text-white mb-2">{category.title}</h3>
              <p className="text-gray-600 dark:text-gray-400 text-sm mb-6">{category.description}</p>

              <div className="space-y-4">
                {category.skills.map((skill, skillIndex) => (
                  <div key={skillIndex}>
                    <div className="flex justify-between items-center mb-2">
                      <span className="text-gray-700 dark:text-gray-300 text-sm font-medium">{skill.name}</span>
                      <span className="text-gradient text-sm font-bold">{skill.level}%</span>
                    </div>
                    <div className="h-2 bg-gray-200 dark:bg-gray-700 rounded-full overflow-hidden">
                      <motion.div
                        initial={{ width: 0 }}
                        whileInView={{ width: `${skill.level}%` }}
                        viewport={{ once: true }}
                        transition={{ duration: 1, delay: categoryIndex * 0.1 + skillIndex * 0.05 }}
                        className="h-full bg-gradient-to-r from-red-500 to-blue-600 rounded-full shadow-glow-duo"
                      />
                    </div>
                  </div>
                ))}
              </div>
            </motion.div>
          ))}
        </div>

        {/* Technologies Showcase */}
        <motion.div
          initial={{ opacity: 0, y: 20 }}
          whileInView={{ opacity: 1, y: 0 }}
          viewport={{ once: true }}
          transition={{ duration: 0.5, delay: 0.3 }}
          className="mt-16 text-center"
        >
          <h3 className="text-2xl font-bold text-gray-900 dark:text-white mb-8">Technologies We Work With</h3>
          <div className="flex flex-wrap justify-center gap-4">
            {['React', 'Next.js', 'TypeScript', 'Node.js', 'Python', 'PostgreSQL', 'MongoDB', 'Docker', 'AWS', 'TensorFlow', 'Solidity', 'GraphQL'].map((tech, index) => (
              <motion.span
                key={index}
                initial={{ opacity: 0, scale: 0.8 }}
                whileInView={{ opacity: 1, scale: 1 }}
                viewport={{ once: true }}
                transition={{ duration: 0.3, delay: index * 0.05 }}
                className="px-6 py-3 bg-gray-100 dark:bg-gray-800/50 backdrop-blur-sm border border-gray-200 dark:border-gray-700 text-gray-700 dark:text-gray-300 rounded-full hover:border-gray-300 dark:hover:border-gray-600 hover:shadow-glow-duo transition-all duration-300 cursor-default"
              >
                {tech}
              </motion.span>
            ))}
          </div>
        </motion.div>

        {/* CTA */}
        <motion.div
          initial={{ opacity: 0, y: 20 }}
          whileInView={{ opacity: 1, y: 0 }}
          viewport={{ once: true }}
          transition={{ duration: 0.5, delay: 0.4 }}
          className="mt-16 text-center"
        >
          <a
            href="#contact"
            className="inline-block px-8 py-4 bg-gradient-to-r from-red-500 to-blue-600 text-white rounded-full font-semibold hover:shadow-glow-duo transition-all duration-300 transform hover:scale-105"
          >
            Let's Work Together
          </a>
        </motion.div>
      </div>
    </section>
  )
}

