import type { ThemeConfig } from 'antd'

export const antdTheme: ThemeConfig = {
  token: {
    // Primary colors - Red to Blue gradient theme
    colorPrimary: '#ef4444',
    colorInfo: '#2563eb',
    colorSuccess: '#10b981',
    colorWarning: '#f59e0b',
    colorError: '#ef4444',
    colorLink: '#ef4444',
    colorLinkHover: '#dc2626',
    colorLinkActive: '#b91c1c',
    
    // Border and radius - Modern rounded design
    borderRadius: 12,
    borderRadiusLG: 16,
    borderRadiusSM: 8,
    borderRadiusXS: 6,
    
    // Fonts
    fontFamily: 'Inter, -apple-system, BlinkMacSystemFont, "Segoe UI", Roboto, sans-serif',
    fontSize: 15,
    fontSizeLG: 16,
    fontSizeSM: 14,
    fontSizeHeading1: 48,
    fontSizeHeading2: 40,
    fontSizeHeading3: 32,
    fontSizeHeading4: 24,
    fontSizeHeading5: 20,
    
    // Spacing
    marginLG: 24,
    marginMD: 16,
    marginSM: 12,
    marginXS: 8,
    marginXXS: 4,
    
    // Dark mode colors optimized for red-blue theme
    colorBgBase: '#030712',
    colorBgContainer: '#111827',
    colorBgElevated: '#1f2937',
    colorBgLayout: '#030712',
    colorBgSpotlight: '#1f2937',
    colorBorder: '#374151',
    colorBorderSecondary: '#1f2937',
    colorText: '#f9fafb',
    colorTextSecondary: '#d1d5db',
    colorTextTertiary: '#9ca3af',
    colorTextQuaternary: '#6b7280',
    colorTextDescription: '#9ca3af',
    colorTextLabel: '#d1d5db',
    colorTextPlaceholder: '#6b7280',
    colorTextDisabled: '#4b5563',
    
    // Shadows with gradient glow
    boxShadow: '0 1px 2px 0 rgba(0, 0, 0, 0.05)',
    boxShadowSecondary: '0 4px 6px -1px rgba(0, 0, 0, 0.1), 0 2px 4px -1px rgba(0, 0, 0, 0.06)',
    
    // Control elements
    controlHeight: 44,
    controlHeightLG: 52,
    controlHeightSM: 36,
    controlHeightXS: 28,
    controlPaddingHorizontal: 16,
    controlPaddingHorizontalSM: 12,
    
    // Line heights
    lineHeight: 1.6,
    lineHeightLG: 1.8,
    lineHeightSM: 1.4,
    
    // Motion - Smooth animations
    motionDurationSlow: '0.3s',
    motionDurationMid: '0.2s',
    motionDurationFast: '0.1s',
    motionEaseInOut: 'cubic-bezier(0.4, 0, 0.2, 1)',
    motionEaseOut: 'cubic-bezier(0, 0, 0.2, 1)',
  },
  
  components: {
    // Button - Gradient primary with glow
    Button: {
      primaryShadow: '0 0 30px rgba(239, 68, 68, 0.3), 0 0 60px rgba(37, 99, 235, 0.2)',
      controlHeight: 44,
      controlHeightLG: 52,
      controlHeightSM: 36,
      fontWeight: 600,
      borderRadius: 12,
      borderRadiusLG: 14,
      borderRadiusSM: 10,
      paddingContentHorizontal: 24,
      colorPrimary: '#ef4444',
      colorPrimaryHover: '#dc2626',
      colorPrimaryActive: '#b91c1c',
      defaultBorderColor: '#374151',
      defaultColor: '#d1d5db',
      defaultBg: 'rgba(31, 41, 55, 0.5)',
      algorithm: true,
    },
    
    // Input - Enhanced with gradient focus
    Input: {
      controlHeight: 44,
      controlHeightLG: 52,
      controlHeightSM: 36,
      paddingBlock: 12,
      paddingBlockLG: 14,
      paddingBlockSM: 10,
      paddingInline: 16,
      paddingInlineLG: 18,
      paddingInlineSM: 14,
      borderRadius: 12,
      borderRadiusLG: 14,
      borderRadiusSM: 10,
      colorBgContainer: 'rgba(31, 41, 55, 0.5)',
      colorBorder: '#374151',
      colorBorderHover: '#4b5563',
      activeBorderColor: '#ef4444',
      hoverBorderColor: '#4b5563',
      activeShadow: '0 0 0 3px rgba(239, 68, 68, 0.2)',
      errorActiveShadow: '0 0 0 3px rgba(220, 38, 38, 0.2)',
      warningActiveShadow: '0 0 0 3px rgba(245, 158, 11, 0.2)',
      colorText: '#f9fafb',
      colorTextPlaceholder: '#6b7280',
      fontSizeLG: 16,
    },
    
    // Select - Custom dropdown with gradient
    Select: {
      controlHeight: 44,
      controlHeightLG: 52,
      controlHeightSM: 36,
      borderRadius: 12,
      borderRadiusLG: 14,
      borderRadiusSM: 10,
      colorBgContainer: 'rgba(31, 41, 55, 0.5)',
      colorBgElevated: '#1f2937',
      colorBorder: '#374151',
      colorPrimaryHover: '#dc2626',
      optionSelectedBg: 'rgba(239, 68, 68, 0.15)',
      optionActiveBg: 'rgba(239, 68, 68, 0.1)',
      optionSelectedColor: '#ef4444',
      optionPadding: '12px 16px',
      multipleItemBg: 'rgba(239, 68, 68, 0.1)',
      multipleItemBorderColor: '#ef4444',
    },
    
    // Textarea - Consistent with Input
    Input: {
      controlHeight: 44,
      paddingBlock: 12,
      paddingInline: 16,
      borderRadius: 12,
      colorBgContainer: 'rgba(31, 41, 55, 0.5)',
      colorBorder: '#374151',
      activeBorderColor: '#ef4444',
      hoverBorderColor: '#4b5563',
      activeShadow: '0 0 0 3px rgba(239, 68, 68, 0.2)',
    },
    
    // Checkbox - Gradient when checked
    Checkbox: {
      borderRadiusSM: 6,
      size: 20,
      colorPrimary: '#ef4444',
      colorPrimaryHover: '#dc2626',
      colorPrimaryBorder: '#ef4444',
      colorBorder: '#374151',
      colorBgContainer: 'rgba(31, 41, 55, 0.5)',
      controlInteractiveSize: 20,
    },
    
    // Radio - Red-blue theme
    Radio: {
      size: 20,
      dotSize: 10,
      colorPrimary: '#ef4444',
      colorPrimaryHover: '#dc2626',
      colorPrimaryActive: '#b91c1c',
      buttonSolidCheckedBg: '#ef4444',
      buttonSolidCheckedColor: '#ffffff',
      buttonSolidCheckedHoverBg: '#dc2626',
      colorBorder: '#374151',
      borderRadius: 12,
    },
    
    // Switch - Gradient toggle
    Switch: {
      colorPrimary: '#ef4444',
      colorPrimaryHover: '#dc2626',
      colorPrimaryBorder: '#dc2626',
      handleSize: 18,
      trackHeight: 24,
      trackMinWidth: 44,
      innerMinMargin: 4,
      innerMaxMargin: 24,
    },
    
    // Modal - Dark with backdrop blur
    Modal: {
      borderRadiusLG: 16,
      contentBg: '#111827',
      headerBg: '#1f2937',
      footerBg: '#111827',
      titleColor: '#f9fafb',
      titleFontSize: 24,
      colorBgMask: 'rgba(0, 0, 0, 0.75)',
      boxShadow: '0 25px 50px -12px rgba(0, 0, 0, 0.5)',
    },
    
    // Drawer - Side panel
    Drawer: {
      colorBgElevated: '#111827',
      colorBgMask: 'rgba(0, 0, 0, 0.75)',
      footerPaddingBlock: 16,
      footerPaddingInline: 24,
    },
    
    // Card - Glass morphism effect
    Card: {
      borderRadiusLG: 16,
      colorBgContainer: 'rgba(31, 41, 55, 0.5)',
      colorBorderSecondary: '#374151',
      paddingLG: 24,
      boxShadow: '0 4px 6px -1px rgba(0, 0, 0, 0.1), 0 2px 4px -1px rgba(0, 0, 0, 0.06)',
    },
    
    // Tabs - Gradient indicator
    Tabs: {
      inkBarColor: '#ef4444',
      itemActiveColor: '#ef4444',
      itemHoverColor: '#f87171',
      itemSelectedColor: '#ef4444',
      itemColor: '#9ca3af',
      titleFontSize: 16,
      titleFontSizeLG: 18,
      titleFontSizeSM: 14,
      cardBg: 'rgba(31, 41, 55, 0.5)',
      cardGutter: 4,
      cardPadding: '12px 16px',
      horizontalItemPadding: '12px 0',
      horizontalItemPaddingLG: '16px 0',
      horizontalItemPaddingSM: '8px 0',
    },
    
    // Dropdown - Elegant menu
    Dropdown: {
      borderRadiusLG: 12,
      borderRadiusSM: 8,
      colorBgElevated: '#1f2937',
      controlItemBgHover: 'rgba(239, 68, 68, 0.1)',
      controlItemBgActive: 'rgba(239, 68, 68, 0.2)',
      controlItemBgActiveHover: 'rgba(239, 68, 68, 0.25)',
      paddingBlock: 8,
      controlPaddingHorizontal: 16,
      boxShadowSecondary: '0 10px 40px rgba(0, 0, 0, 0.3)',
    },
    
    // Menu - Navigation styling
    Menu: {
      itemBg: 'transparent',
      itemHoverBg: 'rgba(239, 68, 68, 0.1)',
      itemActiveBg: 'rgba(239, 68, 68, 0.2)',
      itemSelectedBg: 'rgba(239, 68, 68, 0.2)',
      itemSelectedColor: '#ef4444',
      itemColor: '#d1d5db',
      itemHoverColor: '#f87171',
      borderRadius: 8,
      subMenuItemBg: 'rgba(31, 41, 55, 0.3)',
      popupBg: '#1f2937',
      itemBorderRadius: 8,
      itemMarginBlock: 4,
      itemMarginInline: 4,
      itemPaddingInline: 16,
    },
    
    // Notification - Toast messages
    Notification: {
      colorBgElevated: '#1f2937',
      borderRadiusLG: 12,
      paddingMD: 16,
      paddingContentHorizontalLG: 24,
      width: 384,
    },
    
    // Message - Global messages
    Message: {
      contentBg: '#1f2937',
      borderRadiusLG: 12,
      contentPadding: '12px 16px',
    },
    
    // Tooltip - Hover info
    Tooltip: {
      colorBgSpotlight: '#1f2937',
      borderRadius: 8,
      paddingSM: 8,
      paddingXS: 6,
      colorTextLightSolid: '#f9fafb',
    },
    
    // Tag - Labels and badges
    Tag: {
      defaultBg: 'rgba(31, 41, 55, 0.5)',
      defaultColor: '#d1d5db',
      borderRadiusSM: 6,
      fontSizeSM: 13,
    },
    
    // Badge - Notification badges
    Badge: {
      colorBorderBg: '#111827',
      statusSize: 6,
      dotSize: 6,
      textFontSize: 12,
      textFontSizeSM: 11,
      textFontWeight: 600,
    },
    
    // Alert - Information boxes
    Alert: {
      borderRadiusLG: 12,
      defaultPadding: '12px 16px',
      withDescriptionPadding: '16px 24px',
      colorInfoBg: 'rgba(37, 99, 235, 0.1)',
      colorInfoBorder: 'rgba(37, 99, 235, 0.3)',
      colorSuccessBg: 'rgba(16, 185, 129, 0.1)',
      colorSuccessBorder: 'rgba(16, 185, 129, 0.3)',
      colorWarningBg: 'rgba(245, 158, 11, 0.1)',
      colorWarningBorder: 'rgba(245, 158, 11, 0.3)',
      colorErrorBg: 'rgba(239, 68, 68, 0.1)',
      colorErrorBorder: 'rgba(239, 68, 68, 0.3)',
    },
    
    // Carousel - Image sliders
    Carousel: {
      dotActiveWidth: 24,
      dotHeight: 4,
      dotWidth: 16,
      dotGap: 8,
    },
    
    // Progress - Loading bars
    Progress: {
      defaultColor: '#ef4444',
      remainingColor: '#374151',
      circleTextColor: '#f9fafb',
      lineBorderRadius: 100,
    },
    
    // Skeleton - Loading placeholders
    Skeleton: {
      colorFill: 'rgba(55, 65, 81, 0.5)',
      colorFillContent: 'rgba(75, 85, 99, 0.5)',
      borderRadiusLG: 12,
      borderRadiusSM: 8,
    },
    
    // Spin - Loading spinners
    Spin: {
      colorPrimary: '#ef4444',
      dotSize: 20,
      dotSizeLG: 32,
      dotSizeSM: 14,
    },
    
    // Pagination - Page navigation
    Pagination: {
      itemBg: 'rgba(31, 41, 55, 0.5)',
      itemActiveBg: '#ef4444',
      itemLinkBg: 'rgba(31, 41, 55, 0.5)',
      itemSize: 36,
      itemSizeSM: 28,
      borderRadius: 8,
    },
    
    // Timeline - Event sequences
    Timeline: {
      tailColor: '#374151',
      dotBorderWidth: 3,
      dotBg: '#111827',
    },
    
    // Divider - Section separators
    Divider: {
      colorSplit: '#374151',
      marginLG: 24,
    },
    
    // Form - Input groups
    Form: {
      labelFontSize: 14,
      labelColor: '#d1d5db',
      labelRequiredMarkColor: '#ef4444',
      itemMarginBottom: 24,
      verticalLabelPadding: '0 0 8px',
    },
  },
  
  algorithm: undefined, // We'll handle theme switching manually
}

// Light theme variant (for theme switcher)
export const antdLightTheme: ThemeConfig = {
  token: {
    // Primary colors - Same red-blue theme
    colorPrimary: '#ef4444',
    colorInfo: '#2563eb',
    colorSuccess: '#10b981',
    colorWarning: '#f59e0b',
    colorError: '#ef4444',
    colorLink: '#ef4444',
    colorLinkHover: '#dc2626',
    colorLinkActive: '#b91c1c',
    
    // Border and radius
    borderRadius: 12,
    borderRadiusLG: 16,
    borderRadiusSM: 8,
    borderRadiusXS: 6,
    
    // Fonts
    fontFamily: 'Inter, -apple-system, BlinkMacSystemFont, "Segoe UI", Roboto, sans-serif',
    fontSize: 15,
    fontSizeLG: 16,
    fontSizeSM: 14,
    
    // Spacing
    marginLG: 24,
    marginMD: 16,
    marginSM: 12,
    marginXS: 8,
    marginXXS: 4,
    
    // Light mode colors
    colorBgBase: '#ffffff',
    colorBgContainer: '#f9fafb',
    colorBgElevated: '#ffffff',
    colorBgLayout: '#f3f4f6',
    colorBgSpotlight: '#ffffff',
    colorBorder: '#e5e7eb',
    colorBorderSecondary: '#f3f4f6',
    colorText: '#111827',
    colorTextSecondary: '#4b5563',
    colorTextTertiary: '#6b7280',
    colorTextQuaternary: '#9ca3af',
    colorTextDescription: '#6b7280',
    colorTextLabel: '#374151',
    colorTextPlaceholder: '#9ca3af',
    colorTextDisabled: '#d1d5db',
    
    // Control elements
    controlHeight: 44,
    controlHeightLG: 52,
    controlHeightSM: 36,
    controlHeightXS: 28,
    controlPaddingHorizontal: 16,
    
    // Motion
    motionDurationSlow: '0.3s',
    motionDurationMid: '0.2s',
    motionDurationFast: '0.1s',
    motionEaseInOut: 'cubic-bezier(0.4, 0, 0.2, 1)',
  },
  
  components: {
    Button: {
      primaryShadow: '0 0 30px rgba(239, 68, 68, 0.3), 0 0 60px rgba(37, 99, 235, 0.2)',
      controlHeight: 44,
      controlHeightLG: 52,
      controlHeightSM: 36,
      fontWeight: 600,
      borderRadius: 12,
      paddingContentHorizontal: 24,
      colorPrimary: '#ef4444',
      colorPrimaryHover: '#dc2626',
      colorPrimaryActive: '#b91c1c',
      defaultBorderColor: '#e5e7eb',
      defaultColor: '#374151',
      defaultBg: '#ffffff',
    },
    Input: {
      controlHeight: 44,
      controlHeightLG: 52,
      controlHeightSM: 36,
      paddingBlock: 12,
      paddingInline: 16,
      borderRadius: 12,
      colorBgContainer: '#ffffff',
      colorBorder: '#e5e7eb',
      colorBorderHover: '#d1d5db',
      activeBorderColor: '#ef4444',
      hoverBorderColor: '#d1d5db',
      activeShadow: '0 0 0 3px rgba(239, 68, 68, 0.15)',
      colorText: '#111827',
      colorTextPlaceholder: '#9ca3af',
    },
    Select: {
      controlHeight: 44,
      controlHeightLG: 52,
      controlHeightSM: 36,
      borderRadius: 12,
      colorBgContainer: '#ffffff',
      colorBgElevated: '#ffffff',
      colorBorder: '#e5e7eb',
      colorPrimaryHover: '#dc2626',
      optionSelectedBg: 'rgba(239, 68, 68, 0.1)',
      optionActiveBg: 'rgba(239, 68, 68, 0.05)',
      optionSelectedColor: '#ef4444',
    },
    Checkbox: {
      borderRadiusSM: 6,
      size: 20,
      colorPrimary: '#ef4444',
      colorPrimaryHover: '#dc2626',
      colorPrimaryBorder: '#ef4444',
      colorBorder: '#d1d5db',
      colorBgContainer: '#ffffff',
    },
    Radio: {
      size: 20,
      colorPrimary: '#ef4444',
      colorPrimaryHover: '#dc2626',
      colorBorder: '#d1d5db',
      borderRadius: 12,
    },
    Switch: {
      colorPrimary: '#ef4444',
      colorPrimaryHover: '#dc2626',
    },
    Card: {
      borderRadiusLG: 16,
      colorBgContainer: '#ffffff',
      colorBorderSecondary: '#e5e7eb',
      paddingLG: 24,
    },
    Modal: {
      borderRadiusLG: 16,
      contentBg: '#ffffff',
      headerBg: '#f9fafb',
      footerBg: '#ffffff',
      titleColor: '#111827',
      titleFontSize: 24,
      colorBgMask: 'rgba(0, 0, 0, 0.45)',
    },
    Dropdown: {
      borderRadiusLG: 12,
      colorBgElevated: '#ffffff',
      controlItemBgHover: 'rgba(239, 68, 68, 0.05)',
      controlItemBgActive: 'rgba(239, 68, 68, 0.1)',
    },
    Menu: {
      itemBg: 'transparent',
      itemHoverBg: 'rgba(239, 68, 68, 0.05)',
      itemActiveBg: 'rgba(239, 68, 68, 0.1)',
      itemSelectedBg: 'rgba(239, 68, 68, 0.1)',
      itemSelectedColor: '#ef4444',
      itemColor: '#374151',
      borderRadius: 8,
    },
    Tabs: {
      inkBarColor: '#ef4444',
      itemActiveColor: '#ef4444',
      itemHoverColor: '#f87171',
      itemSelectedColor: '#ef4444',
      itemColor: '#6b7280',
    },
    Alert: {
      borderRadiusLG: 12,
      colorInfoBg: 'rgba(37, 99, 235, 0.1)',
      colorInfoBorder: 'rgba(37, 99, 235, 0.2)',
      colorSuccessBg: 'rgba(16, 185, 129, 0.1)',
      colorSuccessBorder: 'rgba(16, 185, 129, 0.2)',
      colorWarningBg: 'rgba(245, 158, 11, 0.1)',
      colorWarningBorder: 'rgba(245, 158, 11, 0.2)',
      colorErrorBg: 'rgba(239, 68, 68, 0.1)',
      colorErrorBorder: 'rgba(239, 68, 68, 0.2)',
    },
    Progress: {
      defaultColor: '#ef4444',
      remainingColor: '#e5e7eb',
    },
    Tag: {
      defaultBg: '#f3f4f6',
      defaultColor: '#374151',
      borderRadiusSM: 6,
    },
    Form: {
      labelFontSize: 14,
      labelColor: '#374151',
      labelRequiredMarkColor: '#ef4444',
      itemMarginBottom: 24,
    },
  },
}

