import type { TeamMember, Stat, TimelineItem, SocialLink } from './types'

// Site Configuration
export const SITE_CONFIG = {
  name: 'Duo Portfolio',
  description: 'Professional full-stack development duo creating exceptional digital experiences',
  url: 'https://your-domain.com',
  email: 'duoteam.dev@email.com',
  phone: '+1 (555) 123-4567',
  location: 'San Francisco, CA',
}

// Team Members
export const TEAM_MEMBERS: TeamMember[] = [
  {
    name: 'Developer One',
    role: 'Frontend Specialist',
    avatar: 'https://api.dicebear.com/7.x/avataaars/svg?seed=dev1',
    skills: ['React', 'TypeScript', 'UI/UX'],
    bio: 'Passionate about creating beautiful and intuitive user interfaces.',
    social: {
      github: 'https://github.com/dev1',
      linkedin: 'https://linkedin.com/in/dev1',
      twitter: 'https://twitter.com/dev1',
      email: 'dev1@email.com',
    },
  },
  {
    name: 'Developer Two',
    role: 'Backend Specialist',
    avatar: 'https://api.dicebear.com/7.x/avataaars/svg?seed=dev2',
    skills: ['Node.js', 'Databases', 'APIs'],
    bio: 'Expert in building scalable backend systems and robust APIs.',
    social: {
      github: 'https://github.com/dev2',
      linkedin: 'https://linkedin.com/in/dev2',
      twitter: 'https://twitter.com/dev2',
      email: 'dev2@email.com',
    },
  },
]

// Statistics
export const STATS: Stat[] = [
  {
    value: '50+',
    label: 'Projects Completed',
    change: '+12.5%',
    description: 'than last year',
  },
  {
    value: '5.6k+',
    label: 'GitHub Stars',
    change: '+25.4%',
    description: 'Open Source',
  },
  {
    value: '300k+',
    label: 'Lines of Code',
    change: '+8%',
    description: 'Last 30 Days',
  },
  {
    value: '100+',
    label: 'Happy Clients',
    change: '+35.8%',
    description: 'This year',
  },
]

// Journey Timeline
export const JOURNEY: TimelineItem[] = [
  {
    year: '2019',
    title: 'The Beginning',
    description: 'Started our coding journey and formed the duo',
  },
  {
    year: '2020',
    title: 'First Projects',
    description: 'Completed first commercial projects together',
  },
  {
    year: '2021',
    title: 'Full Stack',
    description: 'Mastered full-stack development as a team',
  },
  {
    year: '2022',
    title: 'Scale Up',
    description: 'Built enterprise applications for major clients',
  },
  {
    year: '2023',
    title: 'Innovation',
    description: 'Leading projects with cutting-edge technologies',
  },
]

// Social Links
export const SOCIAL_LINKS: SocialLink[] = [
  {
    platform: 'github',
    url: 'https://github.com/your-team',
    label: 'GitHub',
  },
  {
    platform: 'linkedin',
    url: 'https://linkedin.com/company/your-team',
    label: 'LinkedIn',
  },
  {
    platform: 'twitter',
    url: 'https://twitter.com/your-team',
    label: 'Twitter',
  },
  {
    platform: 'email',
    url: 'mailto:duoteam.dev@email.com',
    label: 'Email',
  },
]

// Navigation Links
export const NAV_LINKS = [
  { href: '#home', label: 'Home' },
  { href: '#about', label: 'About' },
  { href: '#projects', label: 'Projects' },
  { href: '#skills', label: 'Skills' },
  { href: '#contact', label: 'Contact' },
]

// Project Categories
export const PROJECT_CATEGORIES = [
  'All',
  'Full Stack',
  'AI/ML',
  'Real-time',
  'Mobile',
  'Blockchain',
  'Data Science',
] as const

// Technologies
export const TECHNOLOGIES = [
  'React',
  'Next.js',
  'TypeScript',
  'Node.js',
  'Python',
  'PostgreSQL',
  'MongoDB',
  'Docker',
  'AWS',
  'TensorFlow',
  'Solidity',
  'GraphQL',
]

