import { toast, ToastOptions } from 'react-hot-toast'

// Custom toast styles matching the red-blue gradient theme
const baseToastStyle: ToastOptions = {
  duration: 4000,
  style: {
    background: '#1f2937',
    color: '#f3f4f6',
    borderRadius: '12px',
    padding: '16px',
    fontSize: '14px',
    fontWeight: '500',
    boxShadow: '0 10px 40px rgba(0, 0, 0, 0.3), 0 0 30px rgba(239, 68, 68, 0.2), 0 0 60px rgba(37, 99, 235, 0.2)',
    border: '1px solid #374151',
    backdropFilter: 'blur(8px)',
  },
  iconTheme: {
    primary: '#ef4444',
    secondary: '#f3f4f6',
  },
}

const successToastStyle: ToastOptions = {
  ...baseToastStyle,
  style: {
    ...baseToastStyle.style,
    boxShadow: '0 10px 40px rgba(0, 0, 0, 0.3), 0 0 30px rgba(16, 185, 129, 0.3)',
    border: '1px solid rgba(16, 185, 129, 0.3)',
  },
  iconTheme: {
    primary: '#10b981',
    secondary: '#f3f4f6',
  },
}

const errorToastStyle: ToastOptions = {
  ...baseToastStyle,
  style: {
    ...baseToastStyle.style,
    boxShadow: '0 10px 40px rgba(0, 0, 0, 0.3), 0 0 30px rgba(239, 68, 68, 0.3)',
    border: '1px solid rgba(239, 68, 68, 0.3)',
  },
  iconTheme: {
    primary: '#ef4444',
    secondary: '#f3f4f6',
  },
}

const loadingToastStyle: ToastOptions = {
  ...baseToastStyle,
  style: {
    ...baseToastStyle.style,
    boxShadow: '0 10px 40px rgba(0, 0, 0, 0.3), 0 0 30px rgba(37, 99, 235, 0.2)',
    border: '1px solid rgba(37, 99, 235, 0.3)',
  },
  iconTheme: {
    primary: '#2563eb',
    secondary: '#f3f4f6',
  },
}

// Custom toast functions with gradient styles
export const showToast = {
  success: (message: string, options?: ToastOptions) => {
    return toast.success(message, { ...successToastStyle, ...options })
  },
  
  error: (message: string, options?: ToastOptions) => {
    return toast.error(message, { ...errorToastStyle, ...options })
  },
  
  loading: (message: string, options?: ToastOptions) => {
    return toast.loading(message, { ...loadingToastStyle, ...options })
  },
  
  info: (message: string, options?: ToastOptions) => {
    return toast(message, { ...baseToastStyle, ...options })
  },
  
  promise: <T,>(
    promise: Promise<T>,
    msgs: {
      loading: string
      success: string | ((data: T) => string)
      error: string | ((err: any) => string)
    },
    options?: ToastOptions
  ) => {
    return toast.promise(
      promise,
      msgs,
      {
        loading: loadingToastStyle,
        success: successToastStyle,
        error: errorToastStyle,
        ...options,
      }
    )
  },
  
  custom: (message: string | JSX.Element, options?: ToastOptions) => {
    return toast.custom(message, { ...baseToastStyle, ...options })
  },
  
  dismiss: (toastId?: string) => {
    return toast.dismiss(toastId)
  },
}

// Export default toast for direct access
export { toast }
export type { ToastOptions }

