// Team Member Type
export interface TeamMember {
  name: string
  role: string
  avatar: string
  skills: string[]
  bio?: string
  social?: {
    github?: string
    linkedin?: string
    twitter?: string
    email?: string
  }
}

// Project Type
export interface Project {
  id: string
  title: string
  description: string
  longDescription?: string
  image: string
  images?: string[]
  tags: string[]
  category: ProjectCategory
  github?: string
  demo?: string
  featured?: boolean
  date?: string
}

export type ProjectCategory = 
  | 'Full Stack'
  | 'AI/ML'
  | 'Real-time'
  | 'Mobile'
  | 'Blockchain'
  | 'Data Science'
  | 'Other'

// Skill Type
export interface Skill {
  name: string
  level: number
}

export interface SkillCategory {
  title: string
  description: string
  skills: Skill[]
}

// Contact Form Data
export interface ContactFormData {
  name: string
  email: string
  subject: string
  projectType: string
  message: string
}

// Stats Type
export interface Stat {
  value: string
  label: string
  change: string
  description: string
}

// Journey/Timeline Type
export interface TimelineItem {
  year: string
  title: string
  description: string
}

// Social Link Type
export interface SocialLink {
  platform: 'github' | 'linkedin' | 'twitter' | 'email' | 'other'
  url: string
  label: string
}

