import createMiddleware from 'next-intl/middleware'
import { locales, defaultLocale } from './i18n'

export default createMiddleware({
  // A list of all locales that are supported
  locales,

  // Used when no locale matches
  defaultLocale,

  // Always use prefix for the default locale
  localePrefix: 'always',

  // Disable automatic locale detection from browser headers
  localeDetection: false
})

export const config = {
  // Match only internationalized pathnames
  matcher: ['/', '/(ru|en|ua|ka)/:path*', '/((?!api|_next|_vercel|.*\\..*).*)']
}

