# 📄 Resume Directory

## How to Add Your Resume

1. **Create your resume PDF** - Use any tool you like (Canva, Google Docs, Word, LaTeX)
2. **Name the file:** `duo-team-resume.pdf` (or update the filename in About.tsx)
3. **Place it here:** `/public/resume/duo-team-resume.pdf`
4. **That's it!** The download button will automatically work

## Alternative Options

### Option 1: Single Team Resume
```
/public/resume/duo-team-resume.pdf
```

### Option 2: Individual Resumes
```
/public/resume/developer-one-resume.pdf
/public/resume/developer-two-resume.pdf
```

### Option 3: Link to External Resume
Update the button in `components/About.tsx` to link to:
- Google Drive
- Dropbox
- LinkedIn profile
- Personal website

## Current Button Location

The "View Full Resume" button is located in:
- **Component:** `components/About.tsx`
- **Section:** "Let's Connect" (near the end)
- **Function:** `onClick` handler with alert (line ~364)

## To Update

Simply replace the placeholder alert with:

```typescript
onClick={() => {
  window.open('/resume/duo-team-resume.pdf', '_blank')
}}
```

Or download directly:

```typescript
onClick={() => {
  const link = document.createElement('a')
  link.href = '/resume/duo-team-resume.pdf'
  link.download = 'Duo-Team-Resume.pdf'
  link.click()
}}
```

---

**Note:** Make sure your resume is up to date and professional! 🚀

