# 🚀 Инструкция по загрузке на cPanel

**Домен:** landing.trendingnow.ge

---

## 📋 Что нужно сделать

### 1️⃣ Настроить email (НА КОМПЬЮТЕРЕ)

Откройте файл **`env.production.txt`** в этой папке.

Найдите раздел с email и заполните:

```env
# Куда будут приходить сообщения
EMAIL_TO=info@trendingnow.ge

# От кого будут отправляться
EMAIL_FROM=noreply@trendingnow.ge

# Настройки Gmail (или другого)
SMTP_HOST=smtp.gmail.com
SMTP_PORT=587
SMTP_USER=ваш-реальный-email@gmail.com
SMTP_PASSWORD=ваш-пароль-приложения
```

**Как получить пароль приложения Gmail:**
1. Откройте: https://myaccount.google.com/apppasswords
2. Войдите в свой аккаунт
3. Создайте новый пароль для приложения
4. Скопируйте и вставьте в `SMTP_PASSWORD`

**Сохраните файл!**

---

### 2️⃣ Загрузить файлы на сервер

#### Вариант А: Через File Manager в cPanel

1. **Войдите в cPanel**
2. **Откройте File Manager**
3. **Создайте папку** для приложения:
   - Например: `/home/ваш-логин/landing-app/`
4. **Загрузите** ВСЕ файлы из этой папки (`cpanel/`) туда
5. **Переименуйте** файл `env.production.txt` → `.env.production`
   - (точка в начале обязательна!)

#### Вариант Б: Через FTP

1. **Подключитесь** к FTP (FileZilla, WinSCP, и т.д.)
2. **Загрузите** все файлы из `cpanel/` в папку на сервере
3. **Переименуйте** `env.production.txt` → `.env.production`

---

### 3️⃣ Настроить Node.js в cPanel

1. **В cPanel найдите** раздел **"Setup Node.js App"**
   
2. **Нажмите "Create Application"**

3. **Заполните форму:**

```
Node.js version:         18.x (или новее)
Application mode:        Production
Application root:        /home/ваш-логин/landing-app
Application URL:         landing.trendingnow.ge
Application startup:     server.js
```

4. **Environment Variables** (очень важно!)

Нажмите "Add Variable" и добавьте эти переменные одну за одной:

```
NODE_ENV=production
NEXT_PUBLIC_SITE_URL=https://landing.trendingnow.ge
EMAIL_TO=info@trendingnow.ge
EMAIL_FROM=noreply@trendingnow.ge
SMTP_HOST=smtp.gmail.com
SMTP_PORT=587
SMTP_USER=ваш-email@gmail.com
SMTP_PASSWORD=ваш-пароль-приложения
```

**⚠️ Используйте ВАШИ реальные данные!**

5. **Нажмите "Create"**

---

### 4️⃣ Установить зависимости

1. **В cPanel откройте Terminal** (или подключитесь по SSH)

2. **Выполните команды:**

```bash
cd ~/landing-app

npm install --production
```

Это займет несколько минут. Дождитесь завершения!

---

### 5️⃣ Запустить приложение

1. **Вернитесь в "Setup Node.js App"**
2. **Найдите** ваше приложение в списке
3. **Нажмите "Restart"**
4. **Статус** должен быть: **"Running"** ✅

---

## ✅ Готово!

Откройте браузер и проверьте: **https://landing.trendingnow.ge**

### Что должно работать:
- ✅ Сайт открывается
- ✅ Можно переключать языки (EN/RU/UA/KA)
- ✅ Все страницы работают
- ✅ Контактная форма отправляет письма
- ✅ Newsletter работает

---

## 🐛 Если что-то не работает

### Сайт не открывается (502 Bad Gateway)

**Проверьте:**
1. Все файлы загружены?
2. `npm install` выполнен?
3. Приложение в статусе "Running"?
4. Логи в cPanel → Node.js App

**Решение:**
- Restart приложения
- Проверьте логи на ошибки

### Контактная форма не работает

**Проверьте:**
1. Environment Variables добавлены в cPanel?
2. SMTP настройки правильные?
3. Gmail App Password правильный?

**Решение:**
```bash
# В Terminal проверьте переменные:
cd ~/landing-app
node -e "console.log(process.env.SMTP_USER)"
```

Должен показать ваш email. Если пусто - добавьте в Environment Variables!

### Страницы показывают 404

**Решение:**
1. Убедитесь что файлы `i18n.ts` и `middleware.ts` загружены
2. Restart приложения
3. Очистите кэш браузера (Ctrl+F5)

---

## 📞 Нужна помощь?

**Проверьте логи:**
```bash
cd ~/landing-app
tail -f logs/err.log    # Ошибки
tail -f logs/out.log    # Обычные логи
```

**Полезные команды:**
```bash
# Проверить версию Node.js
node --version

# Проверить что приложение запущено
ps aux | grep node

# Перезапустить вручную (если нужно)
npm start
```

---

## 🔄 Как обновить сайт потом

1. **На компьютере** сделайте изменения
2. **Соберите** заново: `npm run build`
3. **Запустите** `prepare-cpanel.bat`
4. **Загрузите** только измененные файлы + папку `.next/`
5. **Restart** в cPanel

---

## ✅ Чеклист

Перед запуском убедитесь:

- [ ] Файл `env.production.txt` настроен (email и пароли)
- [ ] Все файлы загружены на сервер
- [ ] Файл переименован в `.env.production`
- [ ] Node.js приложение создано в cPanel
- [ ] Environment Variables добавлены
- [ ] `npm install --production` выполнен
- [ ] Приложение запущено (статус "Running")
- [ ] Сайт открывается в браузере

---

## 🎉 Успешного запуска!

Ваш сайт будет доступен на **https://landing.trendingnow.ge** 🚀

